/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.grok.Grok;

public final class GrokPatternCreator {
    private static final Logger logger = LogManager.getLogger(GrokPatternCreator.class);
    private static final String PREFACE = "preface";
    private static final String EPILOGUE = "epilogue";
    private static final int MAX_RECURSE_DEPTH = 10;
    private static final List<GrokPatternCandidate> ORDERED_CANDIDATE_GROK_PATTERNS = Arrays.asList(new GrokPatternCandidate("TOMCAT_DATESTAMP", "timestamp"), new GrokPatternCandidate("TIMESTAMP_ISO8601", "timestamp"), new GrokPatternCandidate("DATESTAMP_RFC822", "timestamp"), new GrokPatternCandidate("DATESTAMP_RFC2822", "timestamp"), new GrokPatternCandidate("DATESTAMP_OTHER", "timestamp"), new GrokPatternCandidate("DATESTAMP_EVENTLOG", "timestamp"), new GrokPatternCandidate("SYSLOGTIMESTAMP", "timestamp"), new GrokPatternCandidate("HTTPDATE", "timestamp"), new GrokPatternCandidate("CATALINA_DATESTAMP", "timestamp"), new GrokPatternCandidate("CISCOTIMESTAMP", "timestamp"), new GrokPatternCandidate("DATE", "date"), new GrokPatternCandidate("TIME", "time"), new GrokPatternCandidate("LOGLEVEL", "loglevel"), new GrokPatternCandidate("URI", "uri"), new GrokPatternCandidate("UUID", "uuid"), new GrokPatternCandidate("MAC", "macaddress"), new GrokPatternCandidate("PATH", "path", "(?<!\\w)", "(?!\\w)"), new GrokPatternCandidate("EMAILADDRESS", "email"), new GrokPatternCandidate("IP", "ipaddress"), new GrokPatternCandidate("QUOTEDSTRING", "field", "", ""), new GrokPatternCandidate("NUMBER", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\d)"), new GrokPatternCandidate("BASE16NUM", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\w)"));

    private GrokPatternCreator() {
    }

    public static String findBestGrokMatchFromExamples(String jobId, String regex, Collection<String> examples) {
        String[] fixedRegexBits = regex.split("\\.[*+]\\??");
        if (fixedRegexBits.length == 0) {
            return regex;
        }
        Pattern exampleProcessor = Pattern.compile(regex.replaceAll("(\\.[*+]\\??)", "($1)"), 32);
        ArrayList groupsMatchesFromExamples = new ArrayList(fixedRegexBits.length);
        for (int i = 0; i < fixedRegexBits.length; ++i) {
            groupsMatchesFromExamples.add(new ArrayList(examples.size()));
        }
        for (String example : examples) {
            Matcher matcher = exampleProcessor.matcher(example);
            if (matcher.matches()) {
                assert (matcher.groupCount() == fixedRegexBits.length);
                for (int groupNum = 1; groupNum <= matcher.groupCount(); ++groupNum) {
                    ((Collection)groupsMatchesFromExamples.get(groupNum - 1)).add(matcher.group(groupNum));
                }
                continue;
            }
            assert (example.endsWith("...")) : exampleProcessor.pattern() + " did not match non-truncated example " + example;
            if (example.endsWith("...")) {
                logger.trace(() -> new ParameterizedMessage("[{}] Pattern [{}] did not match truncated example", (Object)jobId, (Object)exampleProcessor.pattern()));
                continue;
            }
            logger.warn("[{}] Pattern [{}] did not match non-truncated example [{}]", (Object)jobId, (Object)exampleProcessor.pattern(), (Object)example);
        }
        HashMap<String, Integer> fieldNameCountStore = new HashMap<String, Integer>();
        StringBuilder overallGrokPatternBuilder = new StringBuilder();
        for (int inBetweenBitNum = 0; inBetweenBitNum < groupsMatchesFromExamples.size(); ++inBetweenBitNum) {
            overallGrokPatternBuilder.append(fixedRegexBits[inBetweenBitNum]);
            GrokPatternCreator.appendBestGrokMatchForStrings(jobId, fieldNameCountStore, overallGrokPatternBuilder, inBetweenBitNum == 0, inBetweenBitNum == fixedRegexBits.length - 1, (Collection)groupsMatchesFromExamples.get(inBetweenBitNum));
        }
        return overallGrokPatternBuilder.toString();
    }

    private static void appendBestGrokMatchForStrings(String jobId, Map<String, Integer> fieldNameCountStore, StringBuilder overallGrokPatternBuilder, boolean isFirst, boolean isLast, Collection<String> mustMatchStrings, int numRecurse) {
        GrokPatternCandidate bestCandidate = null;
        if (!mustMatchStrings.isEmpty()) {
            for (GrokPatternCandidate candidate : ORDERED_CANDIDATE_GROK_PATTERNS) {
                if (!mustMatchStrings.stream().allMatch(arg_0 -> ((Grok)candidate.grok).match(arg_0))) continue;
                bestCandidate = candidate;
                break;
            }
        }
        if (bestCandidate == null || numRecurse >= 10) {
            if (bestCandidate != null) {
                logger.warn("[{}] exited grok discovery early, reached max depth [{}]", (Object)jobId, (Object)10);
            }
            if (isLast) {
                overallGrokPatternBuilder.append(".*");
            } else if (isFirst || mustMatchStrings.stream().anyMatch(String::isEmpty)) {
                overallGrokPatternBuilder.append(".*?");
            } else {
                overallGrokPatternBuilder.append(".+?");
            }
        } else {
            ArrayList<String> prefaces = new ArrayList<String>();
            ArrayList<String> epilogues = new ArrayList<String>();
            GrokPatternCreator.populatePrefacesAndEpilogues(mustMatchStrings, bestCandidate.grok, prefaces, epilogues);
            GrokPatternCreator.appendBestGrokMatchForStrings(jobId, fieldNameCountStore, overallGrokPatternBuilder, isFirst, false, prefaces, numRecurse + 1);
            overallGrokPatternBuilder.append("%{").append(bestCandidate.grokPatternName).append(':').append(GrokPatternCreator.buildFieldName(fieldNameCountStore, bestCandidate.fieldName)).append('}');
            GrokPatternCreator.appendBestGrokMatchForStrings(jobId, fieldNameCountStore, overallGrokPatternBuilder, false, isLast, epilogues, numRecurse + 1);
        }
    }

    static void appendBestGrokMatchForStrings(String jobId, Map<String, Integer> fieldNameCountStore, StringBuilder overallGrokPatternBuilder, boolean isFirst, boolean isLast, Collection<String> mustMatchStrings) {
        GrokPatternCreator.appendBestGrokMatchForStrings(jobId, fieldNameCountStore, overallGrokPatternBuilder, isFirst, isLast, mustMatchStrings, 0);
    }

    static void populatePrefacesAndEpilogues(Collection<String> matchingStrings, Grok grok, Collection<String> prefaces, Collection<String> epilogues) {
        for (String s : matchingStrings) {
            Map captures = grok.captures(s);
            assert (captures != null);
            prefaces.add(captures.getOrDefault(PREFACE, "").toString());
            epilogues.add(captures.getOrDefault(EPILOGUE, "").toString());
        }
    }

    static String buildFieldName(Map<String, Integer> fieldNameCountStore, String fieldName) {
        Integer numberSeen = fieldNameCountStore.compute(fieldName, (k, v) -> 1 + (v == null ? 0 : v));
        if (numberSeen > 1) {
            return fieldName + numberSeen;
        }
        return fieldName;
    }

    static class GrokPatternCandidate {
        final String grokPatternName;
        final String fieldName;
        final Grok grok;

        GrokPatternCandidate(String grokPatternName, String fieldName) {
            this(grokPatternName, fieldName, "\\b", "\\b");
        }

        GrokPatternCandidate(String grokPatternName, String fieldName, String preBreak) {
            this(grokPatternName, fieldName, preBreak, "\\b");
        }

        GrokPatternCandidate(String grokPatternName, String fieldName, String preBreak, String postBreak) {
            this.grokPatternName = grokPatternName;
            this.fieldName = fieldName;
            this.grok = new Grok(Grok.getBuiltinPatterns((boolean)false), "%{DATA:preface}" + preBreak + "%{" + grokPatternName + ":this}" + postBreak + "%{GREEDYDATA:" + GrokPatternCreator.EPILOGUE + "}", arg_0 -> ((Logger)logger).warn(arg_0));
        }
    }
}

