/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;

public class CountingInputStream
extends FilterInputStream {
    private DataCountsReporter dataCountsReporter;
    private int markPosition = 0;
    private int currentPosition = 0;

    public CountingInputStream(InputStream in, DataCountsReporter dataCountsReporter) {
        super(in);
        this.dataCountsReporter = dataCountsReporter;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        this.dataCountsReporter.reportBytesRead(read < 0 ? 0L : 1L);
        this.currentPosition += read < 0 ? 0 : 1;
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        this.dataCountsReporter.reportBytesRead(read < 0 ? 0L : (long)read);
        this.currentPosition += read < 0 ? 0 : read;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.dataCountsReporter.reportBytesRead(read < 0 ? 0L : (long)read);
        this.currentPosition += read < 0 ? 0 : read;
        return read;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markPosition = this.currentPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.dataCountsReporter.reportBytesRead(-(this.currentPosition - this.markPosition));
        this.currentPosition = this.markPosition;
    }
}

