/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

public class RestGetTrainedModelsStatsAction
extends BaseRestHandler {
    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID + "}/_stats")).replaces(RestRequest.Method.GET, "/_ml/inference/{" + TrainedModelConfig.MODEL_ID + "}/_stats", RestApiVersion.V_7).build(), (Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/trained_models/_stats").replaces(RestRequest.Method.GET, "/_ml/inference/_stats", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_trained_models_stats_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)modelId)) {
            modelId = "_all";
        }
        GetTrainedModelsStatsAction.Request request = new GetTrainedModelsStatsAction.Request(modelId);
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        request.setAllowNoResources(restRequest.paramAsBoolean(GetTrainedModelsAction.Request.ALLOW_NO_MATCH.getPreferredName(), request.isAllowNoResources()));
        return channel -> client.execute((ActionType)GetTrainedModelsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

