/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.frozen.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.protocol.xpack.frozen.FreezeRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public final class RestFreezeIndexAction
extends XPackRestHandler {
    public static final String DEPRECATION_WARNING = "Frozen indices are deprecated because they provide no benefit given improvements in heap memory utilization. They will be removed in a future release.";

    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/{index}/_freeze").deprecated(DEPRECATION_WARNING, RestApiVersion.V_7).build(), (Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/{index}/_unfreeze").deprecated(DEPRECATION_WARNING, RestApiVersion.V_7).build());
    }

    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) {
        boolean freeze = request.path().endsWith("/_freeze");
        FreezeRequest freezeRequest = new FreezeRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        freezeRequest.timeout(request.paramAsTime("timeout", freezeRequest.timeout()));
        freezeRequest.masterNodeTimeout(request.paramAsTime("master_timeout", freezeRequest.masterNodeTimeout()));
        freezeRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)freezeRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            freezeRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        freezeRequest.setFreeze(freeze);
        return channel -> client.freeze(freezeRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "freeze_index";
    }
}

