/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.tree;

import java.util.Collection;
import java.util.Iterator;
import org.elasticsearch.xpack.ql.tree.Node;

public abstract class NodeUtils {
    private static final int TO_STRING_LIMIT = 52;

    public static <A extends Node<A>, B extends Node<B>> String diffString(A left, B right) {
        return NodeUtils.diffString(left.toString(), right.toString());
    }

    public static String diffString(String left, String right) {
        String[] leftSplit = left.split("\\n");
        String[] rightSplit = right.split("\\n");
        int leftMaxPadding = 0;
        for (String string : leftSplit) {
            leftMaxPadding = Math.max(string.length(), leftMaxPadding);
        }
        StringBuilder sb = new StringBuilder(left.length() + right.length() + Math.max(left.length(), right.length()) * 3);
        boolean leftAvailable = true;
        boolean rightAvailable = true;
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftAvailable || rightAvailable) {
            String leftRow;
            String rightRow = leftRow = "";
            if (leftIndex < leftSplit.length) {
                leftRow = leftSplit[leftIndex];
            } else {
                leftAvailable = false;
            }
            sb.append(leftRow);
            for (int i = leftRow.length(); i < leftMaxPadding; ++i) {
                sb.append(" ");
            }
            if (rightIndex < rightSplit.length) {
                rightRow = rightSplit[rightIndex];
            } else {
                rightAvailable = false;
            }
            if (leftAvailable || rightAvailable) {
                sb.append(leftRow.equals(rightRow) ? " = " : " ! ");
                sb.append(rightRow);
                sb.append("\n");
            }
            ++leftIndex;
            ++rightIndex;
        }
        return sb.toString();
    }

    public static <E> String limitedToString(Collection<E> c) {
        Iterator<E> it = c.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(56);
        sb.append('[');
        while (true) {
            E e;
            String next;
            String string = next = (e = it.next()) == c ? "(this Collection)" : String.valueOf(e);
            if (next.length() + sb.length() > 52) {
                sb.append(next.substring(0, Math.max(0, 52 - sb.length())));
                sb.append('.').append('.').append(']');
                return sb.toString();
            }
            sb.append(next);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

