/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.encrypted;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public final class CountingInputStream
extends InputStream {
    private final InputStream source;
    private final boolean closeSource;
    long count;
    long mark;
    boolean closed;

    public CountingInputStream(InputStream source, boolean closeSource) {
        this.source = Objects.requireNonNull(source);
        this.closeSource = closeSource;
        this.count = 0L;
        this.mark = -1L;
        this.closed = false;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int result = this.source.read();
        if (result != -1) {
            ++this.count;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.source.read(b, off, len);
        if (result != -1) {
            this.count += (long)result;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.source.skip(n);
        this.count += result;
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.source.mark(readlimit);
        this.mark = this.count;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.source.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.count = this.mark;
        this.source.reset();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.closeSource) {
                this.source.close();
            }
        }
    }
}

