/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import org.elasticsearch.common.Strings;

final class StringFunctionUtils {
    private StringFunctionUtils() {
    }

    static String substring(String s, int start, int length) {
        if (!Strings.hasLength((String)s)) {
            return s;
        }
        if (start < 0) {
            start = 0;
        }
        if (start + 1 > s.length() || length < 0) {
            return "";
        }
        return start + length > s.length() ? s.substring(start) : s.substring(start, start + length);
    }

    static String trimTrailingWhitespaces(String s) {
        int i;
        if (!Strings.hasLength((String)s)) {
            return s;
        }
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }

    static String trimLeadingWhitespaces(String s) {
        int i;
        if (!Strings.hasLength((String)s)) {
            return s;
        }
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }
}

