/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Executable;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.Session;
import org.elasticsearch.xpack.sql.util.Check;

public class SingletonExecutable
implements Executable {
    private final List<Attribute> output;
    private final Object[] values;

    public SingletonExecutable() {
        this(Collections.emptyList(), new Object[0]);
    }

    public SingletonExecutable(List<Attribute> output, Object ... values) {
        Check.isTrue(output.size() == values.length, "Attributes {} and values {} are out of sync", output, values);
        this.output = output;
        this.values = values;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public void execute(Session session, ActionListener<Cursor.Page> listener) {
        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output, this.values)));
    }

    public String toString() {
        return NodeUtils.limitedToString(this.output) + "," + NodeUtils.limitedToString(Arrays.asList(this.values));
    }
}

