/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsUtils;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.input.ChecksumBlobContainerIndexInput;

public abstract class BaseSearchableSnapshotIndexInput
extends BufferedIndexInput {
    protected final Logger logger;
    protected final String name;
    protected final SearchableSnapshotDirectory directory;
    protected final BlobContainer blobContainer;
    protected final BlobStoreIndexShardSnapshot.FileInfo fileInfo;
    protected final IOContext context;
    protected final IndexInputStats stats;
    protected final long offset;
    protected final long length;
    protected final ByteRange headerBlobCacheByteRange;
    protected final ByteRange footerBlobCacheByteRange;
    protected volatile boolean isClone;
    private AtomicBoolean closed;

    public BaseSearchableSnapshotIndexInput(Logger logger, String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long length, ByteRange headerBlobCacheByteRange, ByteRange footerBlobCacheByteRange) {
        super(name, context);
        this.name = Objects.requireNonNull(name);
        this.logger = Objects.requireNonNull(logger);
        this.directory = Objects.requireNonNull(directory);
        this.blobContainer = Objects.requireNonNull(directory.blobContainer());
        this.fileInfo = Objects.requireNonNull(fileInfo);
        this.context = Objects.requireNonNull(context);
        assert (!fileInfo.metadata().hashEqualsContents()) : "this method should only be used with blobs that are NOT stored in metadata's hash field (fileInfo: " + fileInfo + ')';
        this.headerBlobCacheByteRange = Objects.requireNonNull(headerBlobCacheByteRange);
        this.footerBlobCacheByteRange = Objects.requireNonNull(footerBlobCacheByteRange);
        this.stats = Objects.requireNonNull(stats);
        this.offset = offset;
        this.length = length;
        this.closed = new AtomicBoolean(false);
        this.isClone = false;
    }

    public final long length() {
        return this.length;
    }

    protected long getAbsolutePosition() {
        long position = this.getFilePointer() + this.offset;
        assert (position >= 0L) : "absolute position is negative: " + position;
        assert (position <= this.fileInfo.length()) : position + " vs " + this.fileInfo.length();
        return position;
    }

    protected final void readInternal(ByteBuffer b) throws IOException {
        assert (BaseSearchableSnapshotIndexInput.assertCurrentThreadIsNotCacheFetchAsync());
        int bytesToRead = b.remaining();
        if (this.maybeReadChecksumFromFileInfo(b)) {
            this.logger.trace("read footer of file [{}], bypassing all caches", (Object)this.fileInfo.physicalName());
        } else {
            this.doReadInternal(b);
        }
        assert ((long)b.remaining() == 0L) : b.remaining();
        this.stats.addLuceneBytesRead(bytesToRead);
    }

    protected abstract void doReadInternal(ByteBuffer var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean maybeReadChecksumFromFileInfo(ByteBuffer b) throws IOException {
        long checksumPosition;
        int remaining = b.remaining();
        if (remaining > CodecUtil.footerLength()) {
            return false;
        }
        long position = this.getAbsolutePosition();
        if (position < (checksumPosition = this.fileInfo.length() - (long)CodecUtil.footerLength())) {
            return false;
        }
        if (this.isClone) {
            return false;
        }
        boolean success = false;
        try {
            int checksumOffset = SearchableSnapshotsUtils.toIntBytes(Math.subtractExact(position, checksumPosition));
            assert (checksumOffset <= CodecUtil.footerLength()) : checksumOffset;
            assert (0 <= checksumOffset) : checksumOffset;
            byte[] checksum = ChecksumBlobContainerIndexInput.checksumToBytesArray(this.fileInfo.checksum());
            b.put(checksum, checksumOffset, remaining);
            success = true;
        }
        catch (NumberFormatException numberFormatException) {
            assert ((long)b.remaining() == (success ? 0L : (long)remaining)) : b.remaining() + " remaining bytes but success is " + success;
            catch (Throwable throwable) {
                assert ((long)b.remaining() == (success ? 0L : (long)remaining)) : b.remaining() + " remaining bytes but success is " + success;
                throw throwable;
            }
        }
        assert ((long)b.remaining() == (success ? 0L : (long)remaining)) : b.remaining() + " remaining bytes but success is " + success;
        return success;
    }

    protected ByteRange rangeToReadFromBlobCache(long position, int readLength) {
        long end = position + (long)readLength;
        if (this.headerBlobCacheByteRange.contains(position, end)) {
            return this.headerBlobCacheByteRange;
        }
        if (this.footerBlobCacheByteRange.contains(position, end)) {
            return this.footerBlobCacheByteRange;
        }
        return ByteRange.EMPTY;
    }

    protected InputStream openInputStreamFromBlobStore(final long position, final long readLength) throws IOException {
        assert (this.assertCurrentThreadMayAccessBlobStore());
        if ((long)this.fileInfo.numberOfParts() == 1L) {
            assert (position + readLength <= this.fileInfo.partBytes(0)) : "cannot read [" + position + "-" + (position + readLength) + "] from [" + this.fileInfo + "]";
            this.stats.addBlobStoreBytesRequested(readLength);
            return this.blobContainer.readBlob(this.fileInfo.partName(0), position, readLength);
        }
        final int startPart = this.getPartNumberForPosition(position);
        final int endPart = this.getPartNumberForPosition(position + readLength - 1L);
        for (int currentPart = startPart; currentPart <= endPart; ++currentPart) {
            long startInPart = currentPart == startPart ? this.getRelativePositionInPart(position) : 0L;
            long endInPart = currentPart == endPart ? this.getRelativePositionInPart(position + readLength - 1L) + 1L : this.getLengthOfPart(currentPart);
            this.stats.addBlobStoreBytesRequested(endInPart - startInPart);
        }
        return new SlicedInputStream(endPart - startPart + 1){

            protected InputStream openSlice(int slice) throws IOException {
                int currentPart = startPart + slice;
                long startInPart = currentPart == startPart ? BaseSearchableSnapshotIndexInput.this.getRelativePositionInPart(position) : 0L;
                long endInPart = currentPart == endPart ? BaseSearchableSnapshotIndexInput.this.getRelativePositionInPart(position + readLength - 1L) + 1L : BaseSearchableSnapshotIndexInput.this.getLengthOfPart(currentPart);
                return BaseSearchableSnapshotIndexInput.this.blobContainer.readBlob(BaseSearchableSnapshotIndexInput.this.fileInfo.partName(currentPart), startInPart, endInPart - startInPart);
            }
        };
    }

    private int getPartNumberForPosition(long position) {
        this.ensureValidPosition(position);
        int part = Math.toIntExact(position / this.fileInfo.partSize().getBytes());
        assert (part <= this.fileInfo.numberOfParts()) : "part number [" + part + "] exceeds number of parts: " + this.fileInfo.numberOfParts();
        assert (part >= 0) : "part number [" + part + "] is negative";
        return part;
    }

    private long getRelativePositionInPart(long position) {
        this.ensureValidPosition(position);
        long pos = position % this.fileInfo.partSize().getBytes();
        assert (pos < this.fileInfo.partBytes(this.getPartNumberForPosition(pos))) : "position in part [" + pos + "] exceeds part's length";
        assert (pos >= 0L) : "position in part [" + pos + "] is negative";
        return pos;
    }

    protected long getLengthOfPart(int part) {
        return this.fileInfo.partBytes(part);
    }

    private void ensureValidPosition(long position) {
        assert (position >= 0L && position < this.fileInfo.length()) : position + " vs " + this.fileInfo.length();
        if (position < 0L || position >= this.fileInfo.length()) {
            throw new IllegalArgumentException("Position [" + position + "] is invalid for a file of length [" + this.fileInfo.length() + "]");
        }
    }

    public BaseSearchableSnapshotIndexInput clone() {
        BaseSearchableSnapshotIndexInput clone = (BaseSearchableSnapshotIndexInput)super.clone();
        clone.closed = new AtomicBoolean(false);
        clone.isClone = true;
        return clone;
    }

    public String toString() {
        return super.toString() + "[length=" + this.length() + ", file pointer=" + this.getFilePointer() + ", offset=" + this.offset + ']';
    }

    protected String getFullSliceDescription(String sliceDescription) {
        String resourceDesc = super.toString();
        if (sliceDescription != null) {
            return "slice(" + sliceDescription + ") of " + resourceDesc;
        }
        return resourceDesc;
    }

    protected void ensureOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException(this.toString() + " is closed");
        }
    }

    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            if (!this.isClone) {
                this.stats.incrementCloseCount();
            }
            this.doClose();
        }
    }

    public abstract void doClose() throws IOException;

    protected void ensureContext(Predicate<IOContext> predicate) throws IOException {
        if (!predicate.test(this.context)) {
            assert (false) : "this method should not be used with this context " + this.context;
            throw new IOException("Cannot read the index input using context [context=" + this.context + ", input=" + (Object)((Object)this) + ']');
        }
    }

    protected final boolean assertCurrentThreadMayAccessBlobStore() {
        String threadName = Thread.currentThread().getName();
        assert (threadName.contains("[snapshot]") || threadName.contains("[generic]") || threadName.contains("[search]") || threadName.contains("[search_throttled]") || threadName.contains("[searchable_snapshots_cache_fetch_async]") || threadName.contains("[searchable_snapshots_cache_prewarming]") || threadName.startsWith("TEST-") || threadName.startsWith("LuceneTestCase")) : "current thread [" + Thread.currentThread() + "] may not read " + this.fileInfo;
        return true;
    }

    protected static boolean isCacheFetchAsyncThread(String threadName) {
        return threadName.contains("[searchable_snapshots_cache_fetch_async]");
    }

    protected static boolean assertCurrentThreadIsNotCacheFetchAsync() {
        String threadName = Thread.currentThread().getName();
        assert (!BaseSearchableSnapshotIndexInput.isCacheFetchAsyncThread(threadName)) : "expected the current thread [" + threadName + "] to belong to the cache fetch async thread pool";
        return true;
    }
}

