/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.ql.async.QlStatusResponse;

public class EqlSearchResponse
extends ActionResponse
implements ToXContentObject,
QlStatusResponse.AsyncStatus {
    private final Hits hits;
    private final long tookInMillis;
    private final boolean isTimeout;
    private final String asyncExecutionId;
    private final boolean isRunning;
    private final boolean isPartial;
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField HITS = new ParseField("hits", new String[0]);
    private static final ParseField ID = new ParseField("id", new String[0]);
    private static final ParseField IS_RUNNING = new ParseField("is_running", new String[0]);
    private static final ParseField IS_PARTIAL = new ParseField("is_partial", new String[0]);
    private static final InstantiatingObjectParser<EqlSearchResponse, Void> PARSER;

    public EqlSearchResponse(Hits hits, long tookInMillis, boolean isTimeout) {
        this(hits, tookInMillis, isTimeout, null, false, false);
    }

    public EqlSearchResponse(Hits hits, long tookInMillis, boolean isTimeout, String asyncExecutionId, boolean isRunning, boolean isPartial) {
        this.hits = hits == null ? Hits.EMPTY : hits;
        this.tookInMillis = tookInMillis;
        this.isTimeout = isTimeout;
        this.asyncExecutionId = asyncExecutionId;
        this.isRunning = isRunning;
        this.isPartial = isPartial;
    }

    public EqlSearchResponse(StreamInput in) throws IOException {
        super(in);
        this.tookInMillis = in.readVLong();
        this.isTimeout = in.readBoolean();
        this.hits = new Hits(in);
        this.asyncExecutionId = in.readOptionalString();
        this.isPartial = in.readBoolean();
        this.isRunning = in.readBoolean();
    }

    public static EqlSearchResponse fromXContent(XContentParser parser) {
        return (EqlSearchResponse)((Object)PARSER.apply(parser, null));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.tookInMillis);
        out.writeBoolean(this.isTimeout);
        this.hits.writeTo(out);
        out.writeOptionalString(this.asyncExecutionId);
        out.writeBoolean(this.isPartial);
        out.writeBoolean(this.isRunning);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    private XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.asyncExecutionId != null) {
            builder.field(ID.getPreferredName(), this.asyncExecutionId);
        }
        builder.field(IS_PARTIAL.getPreferredName(), this.isPartial);
        builder.field(IS_RUNNING.getPreferredName(), this.isRunning);
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.isTimeout);
        this.hits.toXContent(builder, params);
        return builder;
    }

    public long took() {
        return this.tookInMillis;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public Hits hits() {
        return this.hits;
    }

    public String id() {
        return this.asyncExecutionId;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EqlSearchResponse that = (EqlSearchResponse)((Object)o);
        return Objects.equals(this.hits, that.hits) && Objects.equals(this.tookInMillis, that.tookInMillis) && Objects.equals(this.isTimeout, that.isTimeout) && Objects.equals(this.asyncExecutionId, that.asyncExecutionId);
    }

    public int hashCode() {
        return Objects.hash(this.hits, this.tookInMillis, this.isTimeout, this.asyncExecutionId);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"eql/search_response", (boolean)true, EqlSearchResponse.class);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Hits.fromXContent(p), HITS);
        parser.declareLong(ConstructingObjectParser.constructorArg(), TOOK);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), TIMED_OUT);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), ID);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_RUNNING);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_PARTIAL);
        PARSER = parser.build();
    }

    public static class Hits
    implements Writeable,
    ToXContentFragment {
        public static final Hits EMPTY = new Hits(null, null, null);
        private final List<Event> events;
        private final List<Sequence> sequences;
        private final TotalHits totalHits;
        private static final ConstructingObjectParser<Hits, Void> PARSER = new ConstructingObjectParser("eql/search_response_hits", true, args -> {
            int i = 0;
            List events = (List)args[i++];
            List sequences = (List)args[i++];
            TotalHits totalHits = (TotalHits)args[i];
            return new Hits(events, sequences, totalHits);
        });

        public Hits(@Nullable List<Event> events, @Nullable List<Sequence> sequences, @Nullable TotalHits totalHits) {
            this.events = events;
            this.sequences = sequences;
            this.totalHits = totalHits;
        }

        public Hits(StreamInput in) throws IOException {
            this.totalHits = in.readBoolean() ? Lucene.readTotalHits((StreamInput)in) : null;
            this.events = in.readBoolean() ? in.readList(Event::new) : null;
            List<Sequence> list = this.sequences = in.readBoolean() ? in.readList(Sequence::new) : null;
            if (in.getVersion().before(Version.V_7_10_0) && in.readBoolean()) {
                in.readList(input -> {
                    input.readVInt();
                    input.readGenericValue();
                    input.readFloat();
                    return null;
                });
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            boolean hasTotalHits = this.totalHits != null;
            out.writeBoolean(hasTotalHits);
            if (hasTotalHits) {
                Lucene.writeTotalHits((StreamOutput)out, (TotalHits)this.totalHits);
            }
            if (this.events != null) {
                out.writeBoolean(true);
                out.writeList(this.events);
            } else {
                out.writeBoolean(false);
            }
            if (this.sequences != null) {
                out.writeBoolean(true);
                out.writeList(this.sequences);
            } else {
                out.writeBoolean(false);
            }
            if (out.getVersion().before(Version.V_7_10_0)) {
                out.writeBoolean(false);
            }
        }

        public static Hits fromXContent(XContentParser parser) throws IOException {
            return (Hits)PARSER.parse(parser, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("hits");
            if (this.totalHits != null) {
                builder.startObject("total");
                builder.field("value", this.totalHits.value);
                builder.field("relation", this.totalHits.relation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte");
                builder.endObject();
            }
            if (this.events != null) {
                builder.startArray("events");
                for (Event event : this.events) {
                    event.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.sequences != null) {
                builder.field("sequences", this.sequences);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hits that = (Hits)o;
            return Objects.equals(this.events, that.events) && Objects.equals(this.sequences, that.sequences) && Objects.equals(this.totalHits, that.totalHits);
        }

        public int hashCode() {
            return Objects.hash(this.events, this.sequences, this.totalHits);
        }

        public List<Event> events() {
            return this.events;
        }

        public List<Sequence> sequences() {
            return this.sequences;
        }

        public TotalHits totalHits() {
            return this.totalHits;
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Event.fromXContent(p), new ParseField("events", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Sequence.PARSER, new ParseField("sequences", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHits.parseTotalHitsFragment((XContentParser)p), new ParseField("total", new String[0]));
        }

        private static final class Fields {
            static final String HITS = "hits";
            static final String TOTAL = "total";
            static final String EVENTS = "events";
            static final String SEQUENCES = "sequences";

            private Fields() {
            }
        }
    }

    private static final class Fields {
        static final String TOOK = "took";
        static final String TIMED_OUT = "timed_out";
        static final String HITS = "hits";
        static final String ID = "id";
        static final String IS_RUNNING = "is_running";
        static final String IS_PARTIAL = "is_partial";

        private Fields() {
        }
    }

    public static class Sequence
    implements Writeable,
    ToXContentObject {
        private static final ParseField JOIN_KEYS = new ParseField("join_keys", new String[0]);
        private static final ParseField EVENTS = new ParseField("events", new String[0]);
        private static final ConstructingObjectParser<Sequence, Void> PARSER = new ConstructingObjectParser("eql/search_response_sequence", true, args -> {
            int i = 0;
            List joinKeys = (List)args[i++];
            List events = (List)args[i];
            return new Sequence(joinKeys, events);
        });
        private final List<Object> joinKeys;
        private final List<Event> events;

        public Sequence(List<Object> joinKeys, List<Event> events) {
            this.joinKeys = joinKeys == null ? Collections.emptyList() : joinKeys;
            this.events = events == null ? Collections.emptyList() : events;
        }

        public Sequence(StreamInput in) throws IOException {
            this.joinKeys = (List)in.readGenericValue();
            this.events = in.readList(Event::new);
        }

        public static Sequence fromXContent(XContentParser parser) {
            return (Sequence)PARSER.apply(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.joinKeys);
            out.writeList(this.events);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (!this.joinKeys.isEmpty()) {
                builder.field("join_keys", this.joinKeys);
            }
            if (!this.events.isEmpty()) {
                builder.startArray("events");
                for (Event event : this.events) {
                    event.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Sequence that = (Sequence)o;
            return Objects.equals(this.joinKeys, that.joinKeys) && Objects.equals(this.events, that.events);
        }

        public int hashCode() {
            return Objects.hash(this.joinKeys, this.events);
        }

        public List<Object> joinKeys() {
            return this.joinKeys;
        }

        public List<Event> events() {
            return this.events;
        }

        static {
            PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), JOIN_KEYS, ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Event.fromXContent(p), EVENTS);
        }

        private static final class Fields {
            static final String JOIN_KEYS = "join_keys";
            static final String EVENTS = "events";

            private Fields() {
            }
        }
    }

    public static class Event
    implements Writeable,
    ToXContentObject {
        private static final ParseField INDEX = new ParseField("_index", new String[0]);
        private static final ParseField ID = new ParseField("_id", new String[0]);
        private static final ParseField SOURCE = new ParseField("_source", new String[0]);
        private static final ParseField FIELDS = new ParseField("fields", new String[0]);
        private static final ConstructingObjectParser<Event, Void> PARSER = new ConstructingObjectParser("eql/search_response_event", true, args -> new Event((String)args[0], (String)args[1], (BytesReference)args[2], (Map)args[3]));
        private String index;
        private final String id;
        private final BytesReference source;
        private final Map<String, DocumentField> fetchFields;

        public Event(String index, String id, BytesReference source, Map<String, DocumentField> fetchFields) {
            this.index = index;
            this.id = id;
            this.source = source;
            this.fetchFields = fetchFields;
        }

        public Event(StreamInput in) throws IOException {
            this.index = in.readString();
            this.id = in.readString();
            this.source = in.readBytesReference();
            this.fetchFields = in.getVersion().onOrAfter(Version.V_7_13_0) && in.readBoolean() ? in.readMap(StreamInput::readString, DocumentField::new) : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeString(this.id);
            out.writeBytesReference(this.source);
            if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
                out.writeBoolean(this.fetchFields != null);
                if (this.fetchFields != null) {
                    out.writeMap(this.fetchFields, StreamOutput::writeString, (stream, documentField) -> documentField.writeTo(stream));
                }
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("_index", this.index);
            builder.field("_id", this.id);
            XContentHelper.writeRawField((String)"_source", (BytesReference)this.source, (XContentBuilder)builder, (ToXContent.Params)params);
            if (this.fetchFields != null && !this.fetchFields.isEmpty() && this.fetchFields.values().stream().anyMatch(df -> df.getValues().size() > 0)) {
                builder.startObject("fields");
                for (DocumentField field : this.fetchFields.values()) {
                    if (field.getValues().size() <= 0) continue;
                    field.getValidValuesWriter().toXContent(builder, params);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public static Event fromXContent(XContentParser parser) throws IOException {
            return (Event)PARSER.apply(parser, null);
        }

        public void index(String index) {
            this.index = index;
        }

        public String index() {
            return this.index;
        }

        public String id() {
            return this.id;
        }

        public BytesReference source() {
            return this.source;
        }

        public Map<String, DocumentField> fetchFields() {
            return this.fetchFields;
        }

        public int hashCode() {
            return Objects.hash(this.index, this.id, this.source, this.fetchFields);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Event other = (Event)obj;
            return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id) && Objects.equals(this.source, other.source) && Objects.equals(this.fetchFields, other.fetchFields);
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
                try (XContentBuilder builder = XContentBuilder.builder((XContent)p.contentType().xContent());){
                    builder.copyCurrentStructure(p);
                    BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
                    return bytesReference;
                }
            }, SOURCE);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
                while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                    DocumentField field = DocumentField.fromXContent((XContentParser)p);
                    fields.put(field.getName(), field);
                }
                return fields;
            }, FIELDS);
        }

        private static final class Fields {
            static final String INDEX = "_index";
            static final String ID = "_id";
            static final String SOURCE = "_source";
            static final String FIELDS = "fields";

            private Fields() {
            }
        }
    }
}

