/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.analysis;

import java.util.Collections;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.eql.analysis.VerificationException;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.ql.tree.Node;

public class PreAnalyzer {
    public LogicalPlan preAnalyze(LogicalPlan plan, IndexResolution indices) {
        if (!indices.isValid()) {
            VerificationException cause = new VerificationException(Collections.singletonList(Failure.fail((Node)plan, (String)indices.toString(), (Object[])new Object[0])));
            throw new IndexNotFoundException(indices.toString(), (Throwable)((Object)cause));
        }
        if (!plan.analyzed()) {
            EsRelation esRelation = new EsRelation(plan.source(), indices.get(), false);
            plan = (LogicalPlan)plan.transformUp(UnresolvedRelation.class, r -> esRelation);
            plan.forEachUp(LogicalPlan::setPreAnalyzed);
        }
        return plan;
    }
}

