/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.EqlFunctionDefinition;
import org.elasticsearch.xpack.eql.expression.function.scalar.math.ToNumber;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.Between;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.CIDRMatch;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.Concat;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.EndsWith;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.IndexOf;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.Length;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StartsWith;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringContains;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.Substring;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.ToString;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.Wildcard;
import org.elasticsearch.xpack.ql.ParsingException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseInsensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Check;

public class EqlFunctionRegistry
extends FunctionRegistry {
    public EqlFunctionRegistry() {
        this.register(this.functions());
    }

    EqlFunctionRegistry(FunctionDefinition ... functions) {
        this.register(functions);
    }

    private FunctionDefinition[][] functions() {
        return new FunctionDefinition[][]{{EqlFunctionRegistry.def(Between.class, Between::new, "between"), EqlFunctionRegistry.def(CIDRMatch.class, CIDRMatch::new, (String[])new String[]{"cidrmatch"}), this.def(Concat.class, Concat::new, new String[]{"concat"}), EqlFunctionRegistry.def(EndsWith.class, EndsWith::new, "endswith"), EqlFunctionRegistry.def(IndexOf.class, IndexOf::new, "indexof"), EqlFunctionRegistry.def(Length.class, Length::new, (String[])new String[]{"length"}), EqlFunctionRegistry.def(StartsWith.class, StartsWith::new, "startswith"), EqlFunctionRegistry.def(ToString.class, ToString::new, (String[])new String[]{"string"}), EqlFunctionRegistry.def(StringContains.class, StringContains::new, "stringcontains"), EqlFunctionRegistry.def(Substring.class, Substring::new, (String[])new String[]{"substring"}), EqlFunctionRegistry.def(Wildcard.class, Wildcard::new, "wildcard")}, {EqlFunctionRegistry.def(Add.class, Add::new, (String[])new String[]{"add"}), EqlFunctionRegistry.def(Div.class, Div::new, (String[])new String[]{"divide"}), EqlFunctionRegistry.def(Mod.class, Mod::new, (String[])new String[]{"modulo"}), EqlFunctionRegistry.def(Mul.class, Mul::new, (String[])new String[]{"multiply"}), EqlFunctionRegistry.def(ToNumber.class, ToNumber::new, (String[])new String[]{"number"}), EqlFunctionRegistry.def(Sub.class, Sub::new, (String[])new String[]{"subtract"})}};
    }

    protected String normalize(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    protected static FunctionDefinition def(Class<? extends Function> function, EqlFunctionBuilder builder, String ... names) {
        Check.isTrue((names.length > 0 ? 1 : 0) != 0, (String)"At least one name must be provided for the function");
        String primaryName = names[0];
        List<String> aliases = Arrays.asList(names).subList(1, names.length);
        FunctionDefinition.Builder realBuilder = (uf, cfg, extras) -> {
            try {
                return builder.build(uf.source(), uf.children(), EqlFunctionRegistry.asBool((Object[])extras));
            }
            catch (QlIllegalArgumentException e) {
                throw new ParsingException(uf.source(), "error building [" + primaryName + "]: " + e.getMessage(), new Object[]{e});
            }
        };
        boolean caseAware = CaseInsensitiveScalarFunction.class.isAssignableFrom(function);
        return new EqlFunctionDefinition(primaryName, Collections.unmodifiableList(aliases), function, caseAware, realBuilder);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, BinaryCaseAwareBuilder<T> ctorRef, String ... names) {
        EqlFunctionBuilder builder = (source, children, caseInsensitive) -> {
            if (children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), EqlFunctionRegistry.defaultSensitivityIfNotSet(caseInsensitive));
        };
        return EqlFunctionRegistry.def(function, builder, names);
    }

    private static Boolean defaultSensitivityIfNotSet(Boolean caseInsensitive) {
        return caseInsensitive == null ? Boolean.FALSE : caseInsensitive;
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, TernaryCaseAwareBuilder<T> ctorRef, String ... names) {
        EqlFunctionBuilder builder = (source, children, caseInsensitive) -> {
            boolean hasMinimumTwo = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new QlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new QlIllegalArgumentException("expects exactly three arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null, EqlFunctionRegistry.defaultSensitivityIfNotSet(caseInsensitive));
        };
        return EqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, QuaternaryBuilderCaseAwareBuilder<T> ctorRef, String ... names) {
        EqlFunctionBuilder builder = (source, children, caseInsensitive) -> {
            boolean hasMinimumThree = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumThree && (children.size() > 4 || children.size() < 3)) {
                throw new QlIllegalArgumentException("expects three or four arguments");
            }
            if (!hasMinimumThree && children.size() != 4) {
                throw new QlIllegalArgumentException("expects exactly four arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), (Expression)children.get(2), children.size() == 4 ? (Expression)children.get(3) : null, EqlFunctionRegistry.defaultSensitivityIfNotSet(caseInsensitive));
        };
        return EqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, UnaryVariadicCaseAwareBuilder<T> ctorRef, String ... names) {
        EqlFunctionBuilder builder = (source, children, caseInsensitive) -> {
            if (children.size() < 2) {
                throw new QlIllegalArgumentException("expects at least two arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), children.subList(1, children.size()), EqlFunctionRegistry.defaultSensitivityIfNotSet(caseInsensitive));
        };
        return EqlFunctionRegistry.def(function, builder, names);
    }

    protected static interface QuaternaryBuilderCaseAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5, boolean var6);
    }

    protected static interface BinaryCaseAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, boolean var4);
    }

    protected static interface TernaryCaseAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, boolean var5);
    }

    protected static interface UnaryVariadicCaseAwareBuilder<T> {
        public T build(Source var1, Expression var2, List<Expression> var3, boolean var4);
    }

    protected static interface EqlFunctionBuilder {
        public Function build(Source var1, List<Expression> var2, Boolean var3);
    }
}

