/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.xpack.searchbusinessrules.CappedScoreWeight;
import org.elasticsearch.xpack.searchbusinessrules.CappedScorer;

public final class CappedScoreQuery
extends Query {
    private final Query query;
    private final float maxScore;

    public CappedScoreQuery(Query query, float maxScore) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
        if (!(maxScore > 0.0f)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " maxScore must be >0, " + maxScore + " supplied.");
        }
        this.maxScore = maxScore;
    }

    public Query getQuery() {
        return this.query;
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            return new CappedScoreQuery(rewritten, this.maxScore);
        }
        if (rewritten.getClass() == CappedScoreQuery.class) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            return new CappedScoreQuery(((BoostQuery)rewritten).getQuery(), this.maxScore);
        }
        return super.rewrite(reader);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight innerWeight = searcher.createWeight(this.query, scoreMode, boost);
        if (scoreMode.needsScores()) {
            return new CappedScoreWeight(this, innerWeight, this.maxScore){

                public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                    BulkScorer innerScorer = innerWeight.bulkScorer(context);
                    if (innerScorer == null) {
                        return null;
                    }
                    return new CappedBulkScorer(innerScorer, this, CappedScoreQuery.this.maxScore);
                }

                public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                    final ScorerSupplier innerScorerSupplier = innerWeight.scorerSupplier(context);
                    if (innerScorerSupplier == null) {
                        return null;
                    }
                    return new ScorerSupplier(){

                        public Scorer get(long leadCost) throws IOException {
                            Scorer innerScorer = innerScorerSupplier.get(leadCost);
                            if (scoreMode == ScoreMode.TOP_SCORES) {
                                innerScorer.advanceShallow(0);
                                if (innerScorer.getMaxScore(Integer.MAX_VALUE) <= CappedScoreQuery.this.maxScore) {
                                    return innerScorer;
                                }
                            }
                            return new CappedScorer(innerWeight, innerScorer, CappedScoreQuery.this.maxScore);
                        }

                        public long cost() {
                            return innerScorerSupplier.cost();
                        }
                    };
                }

                public Matches matches(LeafReaderContext context, int doc) throws IOException {
                    return innerWeight.matches(context, doc);
                }

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                    if (scorerSupplier == null) {
                        return null;
                    }
                    return scorerSupplier.get(Long.MAX_VALUE);
                }
            };
        }
        return innerWeight;
    }

    public String toString(String field) {
        return "CappedScore(" + this.query.toString(field) + ')';
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.maxScore == ((CappedScoreQuery)((Object)other)).maxScore && this.query.equals((Object)((CappedScoreQuery)((Object)other)).query);
    }

    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode() + Float.hashCode(this.maxScore);
    }

    protected static class CappedBulkScorer
    extends BulkScorer {
        final BulkScorer bulkScorer;
        final Weight weight;
        final float maxScore;

        public CappedBulkScorer(BulkScorer bulkScorer, Weight weight, float maxScore) {
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.maxScore = maxScore;
        }

        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            return this.bulkScorer.score(this.wrapCollector(collector), acceptDocs, min, max);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){

                public void setScorer(final Scorable scorer) throws IOException {
                    this.in.setScorer((Scorable)new FilterScorable(scorer){

                        public float score() throws IOException {
                            return Math.min(maxScore, this.in.score());
                        }

                        public void setMinCompetitiveScore(float minScore) throws IOException {
                            scorer.setMinCompetitiveScore(minScore);
                        }
                    });
                }
            };
        }

        public long cost() {
            return this.bulkScorer.cost();
        }
    }
}

