﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigateway/APIGatewayRequest.h>
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace APIGateway {
namespace Model {

/**
 */
class RejectDomainNameAccessAssociationRequest : public APIGatewayRequest {
 public:
  AWS_APIGATEWAY_API RejectDomainNameAccessAssociationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RejectDomainNameAccessAssociation"; }

  AWS_APIGATEWAY_API Aws::String SerializePayload() const override;

  AWS_APIGATEWAY_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The ARN of the domain name access association resource. </p>
   */
  inline const Aws::String& GetDomainNameAccessAssociationArn() const { return m_domainNameAccessAssociationArn; }
  inline bool DomainNameAccessAssociationArnHasBeenSet() const { return m_domainNameAccessAssociationArnHasBeenSet; }
  template <typename DomainNameAccessAssociationArnT = Aws::String>
  void SetDomainNameAccessAssociationArn(DomainNameAccessAssociationArnT&& value) {
    m_domainNameAccessAssociationArnHasBeenSet = true;
    m_domainNameAccessAssociationArn = std::forward<DomainNameAccessAssociationArnT>(value);
  }
  template <typename DomainNameAccessAssociationArnT = Aws::String>
  RejectDomainNameAccessAssociationRequest& WithDomainNameAccessAssociationArn(DomainNameAccessAssociationArnT&& value) {
    SetDomainNameAccessAssociationArn(std::forward<DomainNameAccessAssociationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The ARN of the domain name. </p>
   */
  inline const Aws::String& GetDomainNameArn() const { return m_domainNameArn; }
  inline bool DomainNameArnHasBeenSet() const { return m_domainNameArnHasBeenSet; }
  template <typename DomainNameArnT = Aws::String>
  void SetDomainNameArn(DomainNameArnT&& value) {
    m_domainNameArnHasBeenSet = true;
    m_domainNameArn = std::forward<DomainNameArnT>(value);
  }
  template <typename DomainNameArnT = Aws::String>
  RejectDomainNameAccessAssociationRequest& WithDomainNameArn(DomainNameArnT&& value) {
    SetDomainNameArn(std::forward<DomainNameArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainNameAccessAssociationArn;
  bool m_domainNameAccessAssociationArnHasBeenSet = false;

  Aws::String m_domainNameArn;
  bool m_domainNameArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace APIGateway
}  // namespace Aws
