﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Transfer {
namespace Model {

/**
 * <p>Specifies the details for the file location for the file that's being used in
 * the workflow. Only applicable if you are using S3 storage.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/S3FileLocation">AWS
 * API Reference</a></p>
 */
class S3FileLocation {
 public:
  AWS_TRANSFER_API S3FileLocation() = default;
  AWS_TRANSFER_API S3FileLocation(Aws::Utils::Json::JsonView jsonValue);
  AWS_TRANSFER_API S3FileLocation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_TRANSFER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Specifies the S3 bucket that contains the file being used.</p>
   */
  inline const Aws::String& GetBucket() const { return m_bucket; }
  inline bool BucketHasBeenSet() const { return m_bucketHasBeenSet; }
  template <typename BucketT = Aws::String>
  void SetBucket(BucketT&& value) {
    m_bucketHasBeenSet = true;
    m_bucket = std::forward<BucketT>(value);
  }
  template <typename BucketT = Aws::String>
  S3FileLocation& WithBucket(BucketT&& value) {
    SetBucket(std::forward<BucketT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name assigned to the file when it was created in Amazon S3. You use the
   * object key to retrieve the object.</p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  S3FileLocation& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the file version.</p>
   */
  inline const Aws::String& GetVersionId() const { return m_versionId; }
  inline bool VersionIdHasBeenSet() const { return m_versionIdHasBeenSet; }
  template <typename VersionIdT = Aws::String>
  void SetVersionId(VersionIdT&& value) {
    m_versionIdHasBeenSet = true;
    m_versionId = std::forward<VersionIdT>(value);
  }
  template <typename VersionIdT = Aws::String>
  S3FileLocation& WithVersionId(VersionIdT&& value) {
    SetVersionId(std::forward<VersionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The entity tag is a hash of the object. The ETag reflects changes only to the
   * contents of an object, not its metadata.</p>
   */
  inline const Aws::String& GetEtag() const { return m_etag; }
  inline bool EtagHasBeenSet() const { return m_etagHasBeenSet; }
  template <typename EtagT = Aws::String>
  void SetEtag(EtagT&& value) {
    m_etagHasBeenSet = true;
    m_etag = std::forward<EtagT>(value);
  }
  template <typename EtagT = Aws::String>
  S3FileLocation& WithEtag(EtagT&& value) {
    SetEtag(std::forward<EtagT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_bucket;
  bool m_bucketHasBeenSet = false;

  Aws::String m_key;
  bool m_keyHasBeenSet = false;

  Aws::String m_versionId;
  bool m_versionIdHasBeenSet = false;

  Aws::String m_etag;
  bool m_etagHasBeenSet = false;
};

}  // namespace Model
}  // namespace Transfer
}  // namespace Aws
