﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CostExplorer {
namespace Model {

/**
 * <p>Details about the Amazon RDS reservations that Amazon Web Services recommends
 * that you purchase.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/RDSInstanceDetails">AWS
 * API Reference</a></p>
 */
class RDSInstanceDetails {
 public:
  AWS_COSTEXPLORER_API RDSInstanceDetails() = default;
  AWS_COSTEXPLORER_API RDSInstanceDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTEXPLORER_API RDSInstanceDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTEXPLORER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The instance family of the recommended reservation.</p>
   */
  inline const Aws::String& GetFamily() const { return m_family; }
  inline bool FamilyHasBeenSet() const { return m_familyHasBeenSet; }
  template <typename FamilyT = Aws::String>
  void SetFamily(FamilyT&& value) {
    m_familyHasBeenSet = true;
    m_family = std::forward<FamilyT>(value);
  }
  template <typename FamilyT = Aws::String>
  RDSInstanceDetails& WithFamily(FamilyT&& value) {
    SetFamily(std::forward<FamilyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of instance that Amazon Web Services recommends.</p>
   */
  inline const Aws::String& GetInstanceType() const { return m_instanceType; }
  inline bool InstanceTypeHasBeenSet() const { return m_instanceTypeHasBeenSet; }
  template <typename InstanceTypeT = Aws::String>
  void SetInstanceType(InstanceTypeT&& value) {
    m_instanceTypeHasBeenSet = true;
    m_instanceType = std::forward<InstanceTypeT>(value);
  }
  template <typename InstanceTypeT = Aws::String>
  RDSInstanceDetails& WithInstanceType(InstanceTypeT&& value) {
    SetInstanceType(std::forward<InstanceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services Region of the recommended reservation.</p>
   */
  inline const Aws::String& GetRegion() const { return m_region; }
  inline bool RegionHasBeenSet() const { return m_regionHasBeenSet; }
  template <typename RegionT = Aws::String>
  void SetRegion(RegionT&& value) {
    m_regionHasBeenSet = true;
    m_region = std::forward<RegionT>(value);
  }
  template <typename RegionT = Aws::String>
  RDSInstanceDetails& WithRegion(RegionT&& value) {
    SetRegion(std::forward<RegionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The database engine that the recommended reservation supports.</p>
   */
  inline const Aws::String& GetDatabaseEngine() const { return m_databaseEngine; }
  inline bool DatabaseEngineHasBeenSet() const { return m_databaseEngineHasBeenSet; }
  template <typename DatabaseEngineT = Aws::String>
  void SetDatabaseEngine(DatabaseEngineT&& value) {
    m_databaseEngineHasBeenSet = true;
    m_databaseEngine = std::forward<DatabaseEngineT>(value);
  }
  template <typename DatabaseEngineT = Aws::String>
  RDSInstanceDetails& WithDatabaseEngine(DatabaseEngineT&& value) {
    SetDatabaseEngine(std::forward<DatabaseEngineT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The database edition that the recommended reservation supports.</p>
   */
  inline const Aws::String& GetDatabaseEdition() const { return m_databaseEdition; }
  inline bool DatabaseEditionHasBeenSet() const { return m_databaseEditionHasBeenSet; }
  template <typename DatabaseEditionT = Aws::String>
  void SetDatabaseEdition(DatabaseEditionT&& value) {
    m_databaseEditionHasBeenSet = true;
    m_databaseEdition = std::forward<DatabaseEditionT>(value);
  }
  template <typename DatabaseEditionT = Aws::String>
  RDSInstanceDetails& WithDatabaseEdition(DatabaseEditionT&& value) {
    SetDatabaseEdition(std::forward<DatabaseEditionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines whether the recommendation is for a reservation in a single
   * Availability Zone or a reservation with a backup in a second Availability
   * Zone.</p>
   */
  inline const Aws::String& GetDeploymentOption() const { return m_deploymentOption; }
  inline bool DeploymentOptionHasBeenSet() const { return m_deploymentOptionHasBeenSet; }
  template <typename DeploymentOptionT = Aws::String>
  void SetDeploymentOption(DeploymentOptionT&& value) {
    m_deploymentOptionHasBeenSet = true;
    m_deploymentOption = std::forward<DeploymentOptionT>(value);
  }
  template <typename DeploymentOptionT = Aws::String>
  RDSInstanceDetails& WithDeploymentOption(DeploymentOptionT&& value) {
    SetDeploymentOption(std::forward<DeploymentOptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The license model that the recommended reservation supports.</p>
   */
  inline const Aws::String& GetLicenseModel() const { return m_licenseModel; }
  inline bool LicenseModelHasBeenSet() const { return m_licenseModelHasBeenSet; }
  template <typename LicenseModelT = Aws::String>
  void SetLicenseModel(LicenseModelT&& value) {
    m_licenseModelHasBeenSet = true;
    m_licenseModel = std::forward<LicenseModelT>(value);
  }
  template <typename LicenseModelT = Aws::String>
  RDSInstanceDetails& WithLicenseModel(LicenseModelT&& value) {
    SetLicenseModel(std::forward<LicenseModelT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines whether the recommendation is for a current-generation instance.
   * </p>
   */
  inline bool GetCurrentGeneration() const { return m_currentGeneration; }
  inline bool CurrentGenerationHasBeenSet() const { return m_currentGenerationHasBeenSet; }
  inline void SetCurrentGeneration(bool value) {
    m_currentGenerationHasBeenSet = true;
    m_currentGeneration = value;
  }
  inline RDSInstanceDetails& WithCurrentGeneration(bool value) {
    SetCurrentGeneration(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines whether the recommended reservation is size flexible.</p>
   */
  inline bool GetSizeFlexEligible() const { return m_sizeFlexEligible; }
  inline bool SizeFlexEligibleHasBeenSet() const { return m_sizeFlexEligibleHasBeenSet; }
  inline void SetSizeFlexEligible(bool value) {
    m_sizeFlexEligibleHasBeenSet = true;
    m_sizeFlexEligible = value;
  }
  inline RDSInstanceDetails& WithSizeFlexEligible(bool value) {
    SetSizeFlexEligible(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_family;
  bool m_familyHasBeenSet = false;

  Aws::String m_instanceType;
  bool m_instanceTypeHasBeenSet = false;

  Aws::String m_region;
  bool m_regionHasBeenSet = false;

  Aws::String m_databaseEngine;
  bool m_databaseEngineHasBeenSet = false;

  Aws::String m_databaseEdition;
  bool m_databaseEditionHasBeenSet = false;

  Aws::String m_deploymentOption;
  bool m_deploymentOptionHasBeenSet = false;

  Aws::String m_licenseModel;
  bool m_licenseModelHasBeenSet = false;

  bool m_currentGeneration{false};
  bool m_currentGenerationHasBeenSet = false;

  bool m_sizeFlexEligible{false};
  bool m_sizeFlexEligibleHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostExplorer
}  // namespace Aws
