﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime/ChimeRequest.h>
#include <aws/chime/Chime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Chime {
namespace Model {

/**
 */
class DeleteRoomMembershipRequest : public ChimeRequest {
 public:
  AWS_CHIME_API DeleteRoomMembershipRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteRoomMembership"; }

  AWS_CHIME_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Amazon Chime account ID.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  DeleteRoomMembershipRequest& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The room ID.</p>
   */
  inline const Aws::String& GetRoomId() const { return m_roomId; }
  inline bool RoomIdHasBeenSet() const { return m_roomIdHasBeenSet; }
  template <typename RoomIdT = Aws::String>
  void SetRoomId(RoomIdT&& value) {
    m_roomIdHasBeenSet = true;
    m_roomId = std::forward<RoomIdT>(value);
  }
  template <typename RoomIdT = Aws::String>
  DeleteRoomMembershipRequest& WithRoomId(RoomIdT&& value) {
    SetRoomId(std::forward<RoomIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The member ID (user ID or bot ID).</p>
   */
  inline const Aws::String& GetMemberId() const { return m_memberId; }
  inline bool MemberIdHasBeenSet() const { return m_memberIdHasBeenSet; }
  template <typename MemberIdT = Aws::String>
  void SetMemberId(MemberIdT&& value) {
    m_memberIdHasBeenSet = true;
    m_memberId = std::forward<MemberIdT>(value);
  }
  template <typename MemberIdT = Aws::String>
  DeleteRoomMembershipRequest& WithMemberId(MemberIdT&& value) {
    SetMemberId(std::forward<MemberIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_accountId;
  bool m_accountIdHasBeenSet = false;

  Aws::String m_roomId;
  bool m_roomIdHasBeenSet = false;

  Aws::String m_memberId;
  bool m_memberIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Chime
}  // namespace Aws
