﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime/ChimeRequest.h>
#include <aws/chime/Chime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Chime {
namespace Model {

/**
 */
class RedactRoomMessageRequest : public ChimeRequest {
 public:
  AWS_CHIME_API RedactRoomMessageRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RedactRoomMessage"; }

  AWS_CHIME_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Amazon Chime account ID.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  RedactRoomMessageRequest& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The room ID.</p>
   */
  inline const Aws::String& GetRoomId() const { return m_roomId; }
  inline bool RoomIdHasBeenSet() const { return m_roomIdHasBeenSet; }
  template <typename RoomIdT = Aws::String>
  void SetRoomId(RoomIdT&& value) {
    m_roomIdHasBeenSet = true;
    m_roomId = std::forward<RoomIdT>(value);
  }
  template <typename RoomIdT = Aws::String>
  RedactRoomMessageRequest& WithRoomId(RoomIdT&& value) {
    SetRoomId(std::forward<RoomIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The message ID.</p>
   */
  inline const Aws::String& GetMessageId() const { return m_messageId; }
  inline bool MessageIdHasBeenSet() const { return m_messageIdHasBeenSet; }
  template <typename MessageIdT = Aws::String>
  void SetMessageId(MessageIdT&& value) {
    m_messageIdHasBeenSet = true;
    m_messageId = std::forward<MessageIdT>(value);
  }
  template <typename MessageIdT = Aws::String>
  RedactRoomMessageRequest& WithMessageId(MessageIdT&& value) {
    SetMessageId(std::forward<MessageIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_accountId;
  bool m_accountIdHasBeenSet = false;

  Aws::String m_roomId;
  bool m_roomIdHasBeenSet = false;

  Aws::String m_messageId;
  bool m_messageIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Chime
}  // namespace Aws
