﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudfront/CloudFront_EXPORTS.h>
#include <aws/cloudfront/model/KeyGroupConfig.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace CloudFront {
namespace Model {

/**
 * <p>A key group.</p> <p>A key group contains a list of public keys that you can
 * use with <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront
 * signed URLs and signed cookies</a>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/KeyGroup">AWS
 * API Reference</a></p>
 */
class KeyGroup {
 public:
  AWS_CLOUDFRONT_API KeyGroup() = default;
  AWS_CLOUDFRONT_API KeyGroup(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_CLOUDFRONT_API KeyGroup& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_CLOUDFRONT_API void AddToNode(Aws::Utils::Xml::XmlNode& parentNode) const;

  ///@{
  /**
   * <p>The identifier for the key group.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  KeyGroup& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time when the key group was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  KeyGroup& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The key group configuration.</p>
   */
  inline const KeyGroupConfig& GetKeyGroupConfig() const { return m_keyGroupConfig; }
  inline bool KeyGroupConfigHasBeenSet() const { return m_keyGroupConfigHasBeenSet; }
  template <typename KeyGroupConfigT = KeyGroupConfig>
  void SetKeyGroupConfig(KeyGroupConfigT&& value) {
    m_keyGroupConfigHasBeenSet = true;
    m_keyGroupConfig = std::forward<KeyGroupConfigT>(value);
  }
  template <typename KeyGroupConfigT = KeyGroupConfig>
  KeyGroup& WithKeyGroupConfig(KeyGroupConfigT&& value) {
    SetKeyGroupConfig(std::forward<KeyGroupConfigT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  KeyGroupConfig m_keyGroupConfig;
  bool m_keyGroupConfigHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
