﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudtrail/model/CreateDashboardResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CloudTrail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateDashboardResult::CreateDashboardResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

CreateDashboardResult& CreateDashboardResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("DashboardArn")) {
    m_dashboardArn = jsonValue.GetString("DashboardArn");
    m_dashboardArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Name")) {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Type")) {
    m_type = DashboardTypeMapper::GetDashboardTypeForName(jsonValue.GetString("Type"));
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Widgets")) {
    Aws::Utils::Array<JsonView> widgetsJsonList = jsonValue.GetArray("Widgets");
    for (unsigned widgetsIndex = 0; widgetsIndex < widgetsJsonList.GetLength(); ++widgetsIndex) {
      m_widgets.push_back(widgetsJsonList[widgetsIndex].AsObject());
    }
    m_widgetsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TagsList")) {
    Aws::Utils::Array<JsonView> tagsListJsonList = jsonValue.GetArray("TagsList");
    for (unsigned tagsListIndex = 0; tagsListIndex < tagsListJsonList.GetLength(); ++tagsListIndex) {
      m_tagsList.push_back(tagsListJsonList[tagsListIndex].AsObject());
    }
    m_tagsListHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RefreshSchedule")) {
    m_refreshSchedule = jsonValue.GetObject("RefreshSchedule");
    m_refreshScheduleHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TerminationProtectionEnabled")) {
    m_terminationProtectionEnabled = jsonValue.GetBool("TerminationProtectionEnabled");
    m_terminationProtectionEnabledHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
