﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codecommit/model/PostCommentForPullRequestResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodeCommit::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

PostCommentForPullRequestResult::PostCommentForPullRequestResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

PostCommentForPullRequestResult& PostCommentForPullRequestResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("repositoryName")) {
    m_repositoryName = jsonValue.GetString("repositoryName");
    m_repositoryNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("pullRequestId")) {
    m_pullRequestId = jsonValue.GetString("pullRequestId");
    m_pullRequestIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("beforeCommitId")) {
    m_beforeCommitId = jsonValue.GetString("beforeCommitId");
    m_beforeCommitIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("afterCommitId")) {
    m_afterCommitId = jsonValue.GetString("afterCommitId");
    m_afterCommitIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("beforeBlobId")) {
    m_beforeBlobId = jsonValue.GetString("beforeBlobId");
    m_beforeBlobIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("afterBlobId")) {
    m_afterBlobId = jsonValue.GetString("afterBlobId");
    m_afterBlobIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("location")) {
    m_location = jsonValue.GetObject("location");
    m_locationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("comment")) {
    m_comment = jsonValue.GetObject("comment");
    m_commentHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
