﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/ContactFlowVersionSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Connect {
namespace Model {

ContactFlowVersionSummary::ContactFlowVersionSummary(JsonView jsonValue) { *this = jsonValue; }

ContactFlowVersionSummary& ContactFlowVersionSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Arn")) {
    m_arn = jsonValue.GetString("Arn");
    m_arnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("VersionDescription")) {
    m_versionDescription = jsonValue.GetString("VersionDescription");
    m_versionDescriptionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Version")) {
    m_version = jsonValue.GetInt64("Version");
    m_versionHasBeenSet = true;
  }
  return *this;
}

JsonValue ContactFlowVersionSummary::Jsonize() const {
  JsonValue payload;

  if (m_arnHasBeenSet) {
    payload.WithString("Arn", m_arn);
  }

  if (m_versionDescriptionHasBeenSet) {
    payload.WithString("VersionDescription", m_versionDescription);
  }

  if (m_versionHasBeenSet) {
    payload.WithInt64("Version", m_version);
  }

  return payload;
}

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
