﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcampaignsv2/ConnectCampaignsV2Request.h>
#include <aws/connectcampaignsv2/ConnectCampaignsV2_EXPORTS.h>
#include <aws/connectcampaignsv2/model/IntegrationConfig.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ConnectCampaignsV2 {
namespace Model {

/**
 * <p>The request for PutConnectInstanceIntegration API.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/PutConnectInstanceIntegrationRequest">AWS
 * API Reference</a></p>
 */
class PutConnectInstanceIntegrationRequest : public ConnectCampaignsV2Request {
 public:
  AWS_CONNECTCAMPAIGNSV2_API PutConnectInstanceIntegrationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "PutConnectInstanceIntegration"; }

  AWS_CONNECTCAMPAIGNSV2_API Aws::String SerializePayload() const override;

  ///@{

  inline const Aws::String& GetConnectInstanceId() const { return m_connectInstanceId; }
  inline bool ConnectInstanceIdHasBeenSet() const { return m_connectInstanceIdHasBeenSet; }
  template <typename ConnectInstanceIdT = Aws::String>
  void SetConnectInstanceId(ConnectInstanceIdT&& value) {
    m_connectInstanceIdHasBeenSet = true;
    m_connectInstanceId = std::forward<ConnectInstanceIdT>(value);
  }
  template <typename ConnectInstanceIdT = Aws::String>
  PutConnectInstanceIntegrationRequest& WithConnectInstanceId(ConnectInstanceIdT&& value) {
    SetConnectInstanceId(std::forward<ConnectInstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const IntegrationConfig& GetIntegrationConfig() const { return m_integrationConfig; }
  inline bool IntegrationConfigHasBeenSet() const { return m_integrationConfigHasBeenSet; }
  template <typename IntegrationConfigT = IntegrationConfig>
  void SetIntegrationConfig(IntegrationConfigT&& value) {
    m_integrationConfigHasBeenSet = true;
    m_integrationConfig = std::forward<IntegrationConfigT>(value);
  }
  template <typename IntegrationConfigT = IntegrationConfig>
  PutConnectInstanceIntegrationRequest& WithIntegrationConfig(IntegrationConfigT&& value) {
    SetIntegrationConfig(std::forward<IntegrationConfigT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_connectInstanceId;
  bool m_connectInstanceIdHasBeenSet = false;

  IntegrationConfig m_integrationConfig;
  bool m_integrationConfigHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCampaignsV2
}  // namespace Aws
