﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectparticipant/ConnectParticipantRequest.h>
#include <aws/connectparticipant/ConnectParticipant_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ConnectParticipant {
namespace Model {

/**
 */
class GetAuthenticationUrlRequest : public ConnectParticipantRequest {
 public:
  AWS_CONNECTPARTICIPANT_API GetAuthenticationUrlRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetAuthenticationUrl"; }

  AWS_CONNECTPARTICIPANT_API Aws::String SerializePayload() const override;

  AWS_CONNECTPARTICIPANT_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The sessionId provided in the authenticationInitiated event.</p>
   */
  inline const Aws::String& GetSessionId() const { return m_sessionId; }
  inline bool SessionIdHasBeenSet() const { return m_sessionIdHasBeenSet; }
  template <typename SessionIdT = Aws::String>
  void SetSessionId(SessionIdT&& value) {
    m_sessionIdHasBeenSet = true;
    m_sessionId = std::forward<SessionIdT>(value);
  }
  template <typename SessionIdT = Aws::String>
  GetAuthenticationUrlRequest& WithSessionId(SessionIdT&& value) {
    SetSessionId(std::forward<SessionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL where the customer will be redirected after Amazon Cognito authorizes
   * the user.</p>
   */
  inline const Aws::String& GetRedirectUri() const { return m_redirectUri; }
  inline bool RedirectUriHasBeenSet() const { return m_redirectUriHasBeenSet; }
  template <typename RedirectUriT = Aws::String>
  void SetRedirectUri(RedirectUriT&& value) {
    m_redirectUriHasBeenSet = true;
    m_redirectUri = std::forward<RedirectUriT>(value);
  }
  template <typename RedirectUriT = Aws::String>
  GetAuthenticationUrlRequest& WithRedirectUri(RedirectUriT&& value) {
    SetRedirectUri(std::forward<RedirectUriT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The authentication token associated with the participant's connection.</p>
   */
  inline const Aws::String& GetConnectionToken() const { return m_connectionToken; }
  inline bool ConnectionTokenHasBeenSet() const { return m_connectionTokenHasBeenSet; }
  template <typename ConnectionTokenT = Aws::String>
  void SetConnectionToken(ConnectionTokenT&& value) {
    m_connectionTokenHasBeenSet = true;
    m_connectionToken = std::forward<ConnectionTokenT>(value);
  }
  template <typename ConnectionTokenT = Aws::String>
  GetAuthenticationUrlRequest& WithConnectionToken(ConnectionTokenT&& value) {
    SetConnectionToken(std::forward<ConnectionTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sessionId;
  bool m_sessionIdHasBeenSet = false;

  Aws::String m_redirectUri;
  bool m_redirectUriHasBeenSet = false;

  Aws::String m_connectionToken;
  bool m_connectionTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectParticipant
}  // namespace Aws
