﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/databrew/model/StartProjectSessionRequest.h>

#include <utility>

using namespace Aws::GlueDataBrew::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartProjectSessionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_assumeControlHasBeenSet) {
    payload.WithBool("AssumeControl", m_assumeControl);
  }

  return payload.View().WriteReadable();
}
