/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class ExponentialPower
extends AbstractContinousDistribution {
    protected double tau;
    private double s;
    private double sm1;
    private double tau_set = -1.0;
    protected static ExponentialPower shared = new ExponentialPower(1.0, AbstractDistribution.makeDefaultGenerator());

    public ExponentialPower(double d2, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.tau);
    }

    public double nextDouble(double d2) {
        double d3;
        double d4;
        double d5;
        if (d2 != this.tau_set) {
            this.s = 1.0 / d2;
            this.sm1 = 1.0 - this.s;
            this.tau_set = d2;
        }
        do {
            d3 = this.randomGenerator.raw();
            d3 = 2.0 * d3 - 1.0;
            double d6 = Math.abs(d3);
            d5 = this.randomGenerator.raw();
            if (d6 <= this.sm1) {
                d4 = d6;
                continue;
            }
            double d7 = d2 * (1.0 - d6);
            d4 = this.sm1 - this.s * Math.log(d7);
            d5 *= d7;
        } while (Math.log(d5) > -Math.exp(Math.log(d4) * d2));
        if (d3 < 0.0) {
            return d4;
        }
        return -d4;
    }

    public void setState(double d2) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException();
        }
        this.tau = d2;
    }

    public static double staticNextDouble(double d2) {
        ExponentialPower exponentialPower = shared;
        synchronized (exponentialPower) {
            double d3 = shared.nextDouble(d2);
            return d3;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.tau + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        ExponentialPower exponentialPower = shared;
        synchronized (exponentialPower) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

