/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.QueryConnectionTester;
import com.mchange.v2.c3p0.SQLWarnings;
import com.mchange.v2.c3p0.UnifiedConnectionTester;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractC3P0PooledConnection;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    private static final boolean ASYNCHRONOUS_CONNECTION_EVENT_LISTENER = false;
    private static final Throwable[] EMPTY_THROWABLE_HOLDER = new Throwable[1];
    static final MLogger logger = MLog.getLogger(C3P0PooledConnectionPool.class);
    final ResourcePool rp;
    final ConnectionEventListener cl = new ConnectionEventListenerImpl();
    final ConnectionTester connectionTester;
    final GooGooStatementCache scache;
    final int checkoutTimeout;
    final AsynchronousRunner sharedTaskRunner;
    final ThrowableHolderPool thp = new ThrowableHolderPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(ConnectionPoolDataSource cpds, DbAuth auth, int min, int max, int start, int inc, int acq_retry_attempts, int acq_retry_delay, boolean break_after_acq_failure, int checkoutTimeout, int idleConnectionTestPeriod, int maxIdleTime, int maxIdleTimeExcessConnections, int maxConnectionAge, int propertyCycle, int unreturnedConnectionTimeout, boolean debugUnreturnedConnectionStackTraces, boolean testConnectionOnCheckout, boolean testConnectionOnCheckin, int maxStatements, int maxStatementsPerConnection, ConnectionTester connectionTester, ConnectionCustomizer connectionCustomizer, String testQuery, ResourcePoolFactory fact, ThreadPoolAsynchronousRunner taskRunner, String parentDataSourceIdentityToken) throws SQLException {
        try {
            this.scache = maxStatements > 0 && maxStatementsPerConnection > 0 ? new DoubleMaxStatementCache(taskRunner, maxStatements, maxStatementsPerConnection) : (maxStatementsPerConnection > 0 ? new PerConnectionMaxOnlyStatementCache(taskRunner, maxStatementsPerConnection) : (maxStatements > 0 ? new GlobalMaxOnlyStatementCache(taskRunner, maxStatements) : null));
            this.connectionTester = connectionTester;
            this.checkoutTimeout = checkoutTimeout;
            this.sharedTaskRunner = taskRunner;
            class PooledConnectionResourcePoolManager
            implements ResourcePool.Manager {
                final boolean connectionTesterIsDefault;
                final boolean c3p0PooledConnections;
                private final /* synthetic */ ConnectionTester val$connectionTester;
                private final /* synthetic */ ConnectionPoolDataSource val$cpds;
                private final /* synthetic */ ConnectionCustomizer val$connectionCustomizer;
                private final /* synthetic */ DbAuth val$auth;
                private final /* synthetic */ String val$parentDataSourceIdentityToken;
                private final /* synthetic */ boolean val$testConnectionOnCheckout;
                private final /* synthetic */ boolean val$testConnectionOnCheckin;
                private final /* synthetic */ String val$testQuery;

                PooledConnectionResourcePoolManager(ConnectionTester connectionTester, ConnectionPoolDataSource connectionPoolDataSource, ConnectionCustomizer connectionCustomizer, DbAuth dbAuth, String string, boolean bl, boolean bl2, String string2) {
                    this.val$connectionTester = connectionTester;
                    this.val$cpds = connectionPoolDataSource;
                    this.val$connectionCustomizer = connectionCustomizer;
                    this.val$auth = dbAuth;
                    this.val$parentDataSourceIdentityToken = string;
                    this.val$testConnectionOnCheckout = bl;
                    this.val$testConnectionOnCheckin = bl2;
                    this.val$testQuery = string2;
                    this.connectionTesterIsDefault = this.val$connectionTester instanceof DefaultConnectionTester;
                    this.c3p0PooledConnections = this.val$cpds instanceof WrapperConnectionPoolDataSource;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object acquireResource() throws Exception {
                    PooledConnection out;
                    if (this.val$connectionCustomizer == null) {
                        out = this.val$auth.equals(C3P0ImplUtils.NULL_AUTH) ? this.val$cpds.getPooledConnection() : this.val$cpds.getPooledConnection(this.val$auth.getUser(), this.val$auth.getPassword());
                    } else {
                        try {
                            WrapperConnectionPoolDataSourceBase wcpds = (WrapperConnectionPoolDataSourceBase)((Object)this.val$cpds);
                            out = this.val$auth.equals(C3P0ImplUtils.NULL_AUTH) ? wcpds.getPooledConnection(this.val$connectionCustomizer, this.val$parentDataSourceIdentityToken) : wcpds.getPooledConnection(this.val$auth.getUser(), this.val$auth.getPassword(), this.val$connectionCustomizer, this.val$parentDataSourceIdentityToken);
                        }
                        catch (ClassCastException e2) {
                            throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 ConnectionPoolDataSource. ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), e2);
                        }
                    }
                    try {
                        if (C3P0PooledConnectionPool.this.scache != null) {
                            if (this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)out).initStatementCache(C3P0PooledConnectionPool.this.scache);
                            } else {
                                logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                            }
                        }
                        Connection con = null;
                        try {
                            con = out.getConnection();
                            SQLWarnings.logAndClearWarnings(con);
                        }
                        finally {
                            ConnectionUtils.attemptClose(con);
                        }
                        out.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        PooledConnection pooledConnection = out;
                        return pooledConnection;
                    }
                    catch (Exception e3) {
                        block20: {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.warning("A PooledConnection was acquired, but an Exception occurred while preparing it for use. Attempting to destroy.");
                            }
                            try {
                                this.destroyResource(out);
                            }
                            catch (Exception e2) {
                                if (!logger.isLoggable(MLevel.WARNING)) break block20;
                                logger.log(MLevel.WARNING, "An Exception occurred while trying to close partially acquired PooledConnection.", e2);
                            }
                        }
                        throw e3;
                    }
                    finally {
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest(this + ".acquireResource() returning. ");
                        }
                    }
                }

                public void refurbishResourceOnCheckout(Object resc) throws Exception {
                    if (this.val$testConnectionOnCheckout) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            this.finerLoggingTestPooledConnection(resc, "CHECKOUT");
                        } else {
                            this.testPooledConnection(resc);
                        }
                    }
                    if (this.val$connectionCustomizer != null) {
                        Connection physicalConnection = null;
                        try {
                            physicalConnection = ((AbstractC3P0PooledConnection)resc).getPhysicalConnection();
                            this.val$connectionCustomizer.onCheckOut(physicalConnection, this.val$parentDataSourceIdentityToken);
                        }
                        catch (ClassCastException e2) {
                            throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + resc + "; ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), e2);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void refurbishResourceOnCheckin(Object resc) throws Exception {
                    if (this.val$connectionCustomizer != null) {
                        Connection physicalConnection = null;
                        try {
                            physicalConnection = ((AbstractC3P0PooledConnection)resc).getPhysicalConnection();
                            this.val$connectionCustomizer.onCheckIn(physicalConnection, this.val$parentDataSourceIdentityToken);
                            SQLWarnings.logAndClearWarnings(physicalConnection);
                        }
                        catch (ClassCastException e2) {
                            throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + resc + "; ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), e2);
                        }
                    }
                    PooledConnection pc = (PooledConnection)resc;
                    Connection con = null;
                    try {
                        pc.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        con = pc.getConnection();
                        SQLWarnings.logAndClearWarnings(con);
                    }
                    catch (Throwable throwable) {
                        ConnectionUtils.attemptClose(con);
                        pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        throw throwable;
                    }
                    ConnectionUtils.attemptClose(con);
                    pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    if (!this.val$testConnectionOnCheckin) return;
                    if (logger.isLoggable(MLevel.FINER)) {
                        this.finerLoggingTestPooledConnection(resc, "CHECKIN");
                        return;
                    }
                    this.testPooledConnection(resc);
                }

                public void refurbishIdleResource(Object resc) throws Exception {
                    if (logger.isLoggable(MLevel.FINER)) {
                        this.finerLoggingTestPooledConnection(resc, "IDLE CHECK");
                    } else {
                        this.testPooledConnection(resc);
                    }
                }

                private void finerLoggingTestPooledConnection(Object resc, String testImpetus) throws Exception {
                    logger.finer("Testing PooledConnection [" + resc + "] on " + testImpetus + ".");
                    try {
                        this.testPooledConnection(resc);
                        logger.finer("Test of PooledConnection [" + resc + "] on " + testImpetus + " has SUCCEEDED.");
                    }
                    catch (Exception e2) {
                        logger.log(MLevel.FINER, "Test of PooledConnection [" + resc + "] on " + testImpetus + " has FAILED.", e2);
                        e2.fillInStackTrace();
                        throw e2;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private void testPooledConnection(Object resc) throws Exception {
                    int status;
                    Throwable rootCause;
                    block25: {
                        Connection conn;
                        Throwable[] throwableHolder;
                        PooledConnection pc;
                        block27: {
                            block26: {
                                pc = (PooledConnection)resc;
                                throwableHolder = EMPTY_THROWABLE_HOLDER;
                                conn = null;
                                rootCause = null;
                                try {
                                    block24: {
                                        try {
                                            pc.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                            conn = pc.getConnection();
                                            Connection testConn = C3P0PooledConnectionPool.this.scache != null ? (this.val$testQuery == null && this.connectionTesterIsDefault && this.c3p0PooledConnections ? ((AbstractC3P0PooledConnection)pc).getPhysicalConnection() : conn) : (this.c3p0PooledConnections ? ((AbstractC3P0PooledConnection)pc).getPhysicalConnection() : conn);
                                            if (this.val$testQuery == null) {
                                                status = this.val$connectionTester.activeCheckConnection(testConn);
                                                break block24;
                                            }
                                            if (this.val$connectionTester instanceof UnifiedConnectionTester) {
                                                throwableHolder = C3P0PooledConnectionPool.this.thp.getThrowableHolder();
                                                status = ((UnifiedConnectionTester)this.val$connectionTester).activeCheckConnection(testConn, this.val$testQuery, throwableHolder);
                                                break block24;
                                            }
                                            if (this.val$connectionTester instanceof QueryConnectionTester) {
                                                status = ((QueryConnectionTester)this.val$connectionTester).activeCheckConnection(testConn, this.val$testQuery);
                                            } else {
                                                logger.warning("[c3p0] testQuery '" + this.val$testQuery + "' ignored. Please set a ConnectionTester that implements " + "com.mchange.v2.c3p0.QueryConnectionTester, or use the " + "DefaultConnectionTester, to test with the testQuery.");
                                                status = this.val$connectionTester.activeCheckConnection(testConn);
                                            }
                                        }
                                        catch (Exception e2) {
                                            logger.log(MLevel.FINE, "A Connection test failed with an Exception.", e2);
                                            status = -1;
                                            rootCause = e2;
                                            Object var9_10 = null;
                                            if (rootCause == null) {
                                                rootCause = throwableHolder[0];
                                            } else if (throwableHolder[0] != null && logger.isLoggable(MLevel.FINE)) {
                                                logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableHolder[0]);
                                            }
                                            if (throwableHolder != EMPTY_THROWABLE_HOLDER) {
                                                C3P0PooledConnectionPool.this.thp.returnThrowableHolder(throwableHolder);
                                            }
                                            ConnectionUtils.attemptClose(conn);
                                            pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                            break block25;
                                        }
                                    }
                                    Object var9_9 = null;
                                    if (rootCause != null) break block26;
                                }
                                catch (Throwable throwable) {
                                    Object var9_11 = null;
                                    if (rootCause == null) {
                                        rootCause = throwableHolder[0];
                                    } else if (throwableHolder[0] != null && logger.isLoggable(MLevel.FINE)) {
                                        logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableHolder[0]);
                                    }
                                    if (throwableHolder != EMPTY_THROWABLE_HOLDER) {
                                        C3P0PooledConnectionPool.this.thp.returnThrowableHolder(throwableHolder);
                                    }
                                    ConnectionUtils.attemptClose(conn);
                                    pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                    throw throwable;
                                }
                                rootCause = throwableHolder[0];
                                break block27;
                            }
                            if (throwableHolder[0] != null && logger.isLoggable(MLevel.FINE)) {
                                logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableHolder[0]);
                            }
                        }
                        if (throwableHolder != EMPTY_THROWABLE_HOLDER) {
                            C3P0PooledConnectionPool.this.thp.returnThrowableHolder(throwableHolder);
                        }
                        ConnectionUtils.attemptClose(conn);
                        pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    }
                    switch (status) {
                        case 0: {
                            return;
                        }
                        case -8: {
                            C3P0PooledConnectionPool.this.rp.resetPool();
                        }
                        case -1: {
                            SQLException throwMe;
                            if (rootCause == null) {
                                throwMe = new SQLException("Connection is invalid");
                                throw throwMe;
                            }
                            throwMe = SqlUtils.toSQLException("Connection is invalid", rootCause);
                            throw throwMe;
                        }
                    }
                    throw new Error("Bad Connection Tester (" + this.val$connectionTester + ") " + "returned invalid status (" + status + ").");
                }

                public void destroyResource(Object resc) throws Exception {
                    try {
                        block9: {
                            if (this.val$connectionCustomizer != null) {
                                Connection physicalConnection = null;
                                try {
                                    physicalConnection = ((AbstractC3P0PooledConnection)resc).getPhysicalConnection();
                                    this.val$connectionCustomizer.onDestroy(physicalConnection, this.val$parentDataSourceIdentityToken);
                                }
                                catch (ClassCastException e2) {
                                    throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + resc + "; ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), e2);
                                }
                                catch (Exception e3) {
                                    if (!logger.isLoggable(MLevel.WARNING)) break block9;
                                    logger.log(MLevel.WARNING, "An exception occurred while executing the onDestroy() method of " + this.val$connectionCustomizer + ". c3p0 will attempt to destroy the target Connection regardless, but this issue " + " should be investigated and fixed.", e3);
                                }
                            }
                        }
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Preparing to destroy PooledConnection: " + resc);
                        }
                        ((PooledConnection)resc).close();
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Successfully destroyed PooledConnection: " + resc);
                        }
                    }
                    catch (Exception e4) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Failed to destroy PooledConnection: " + resc);
                        }
                        throw e4;
                    }
                }
            }
            PooledConnectionResourcePoolManager manager = new PooledConnectionResourcePoolManager(connectionTester, cpds, connectionCustomizer, auth, parentDataSourceIdentityToken, testConnectionOnCheckout, testConnectionOnCheckin, testQuery);
            ResourcePoolFactory resourcePoolFactory = fact;
            synchronized (resourcePoolFactory) {
                fact.setMin(min);
                fact.setMax(max);
                fact.setStart(start);
                fact.setIncrement(inc);
                fact.setIdleResourceTestPeriod(idleConnectionTestPeriod * 1000);
                fact.setResourceMaxIdleTime(maxIdleTime * 1000);
                fact.setExcessResourceMaxIdleTime(maxIdleTimeExcessConnections * 1000);
                fact.setResourceMaxAge(maxConnectionAge * 1000);
                fact.setExpirationEnforcementDelay(propertyCycle * 1000);
                fact.setDestroyOverdueResourceTime(unreturnedConnectionTimeout * 1000);
                fact.setDebugStoreCheckoutStackTrace(debugUnreturnedConnectionStackTraces);
                fact.setAcquisitionRetryAttempts(acq_retry_attempts);
                fact.setAcquisitionRetryDelay(acq_retry_delay);
                fact.setBreakOnAcquisitionFailure(break_after_acq_failure);
                this.rp = fact.createPool(manager);
            }
        }
        catch (ResourcePoolException e2) {
            throw SqlUtils.toSQLException(e2);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            return (PooledConnection)this.rp.checkoutResource(this.checkoutTimeout);
        }
        catch (TimeoutException e2) {
            throw SqlUtils.toSQLException("An attempt by a client to checkout a Connection has timed out.", e2);
        }
        catch (CannotAcquireResourceException e3) {
            throw SqlUtils.toSQLException("Connections could not be acquired from the underlying database!", "08001", e3);
        }
        catch (Exception e4) {
            throw SqlUtils.toSQLException(e4);
        }
    }

    public void checkinPooledConnection(PooledConnection pcon) throws SQLException {
        try {
            this.rp.checkinResource(pcon);
        }
        catch (ResourcePoolException e2) {
            throw SqlUtils.toSQLException(e2);
        }
    }

    public float getEffectivePropertyCycle() throws SQLException {
        try {
            return (float)this.rp.getEffectiveExpirationEnforcementDelay() / 1000.0f;
        }
        catch (ResourcePoolException e2) {
            throw SqlUtils.toSQLException(e2);
        }
    }

    public int getNumThreadsAwaitingCheckout() throws SQLException {
        try {
            return this.rp.getNumCheckoutWaiters();
        }
        catch (ResourcePoolException e2) {
            throw SqlUtils.toSQLException(e2);
        }
    }

    public int getStatementCacheNumStatements() {
        return this.scache == null ? 0 : this.scache.getNumStatements();
    }

    public int getStatementCacheNumCheckedOut() {
        return this.scache == null ? 0 : this.scache.getNumStatementsCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatements() {
        return this.scache == null ? 0 : this.scache.getNumConnectionsWithCachedStatements();
    }

    public String dumpStatementCacheStatus() {
        return this.scache == null ? "Statement caching disabled." : this.scache.dumpStatementCacheStatus();
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean close_outstanding_connections) throws SQLException {
        Exception throwMe = null;
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException e2) {
            throwMe = e2;
        }
        try {
            this.rp.close(close_outstanding_connections);
        }
        catch (ResourcePoolException e3) {
            if (throwMe != null && logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while closing the StatementCache.", throwMe);
            }
            throwMe = e3;
        }
        if (throwMe != null) {
            throw SqlUtils.toSQLException(throwMe);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumBusyConnections() throws SQLException {
        try {
            ResourcePool resourcePool = this.rp;
            synchronized (resourcePool) {
                return this.rp.getAwaitingCheckinCount() - this.rp.getExcludedCount();
            }
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public long getStartTime() throws SQLException {
        try {
            return this.rp.getStartTime();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public long getUpTime() throws SQLException {
        try {
            return this.rp.getUpTime();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public long getNumFailedCheckins() throws SQLException {
        try {
            return this.rp.getNumFailedCheckins();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public long getNumFailedCheckouts() throws SQLException {
        try {
            return this.rp.getNumFailedCheckouts();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public long getNumFailedIdleTests() throws SQLException {
        try {
            return this.rp.getNumFailedIdleTests();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public Throwable getLastCheckinFailure() throws SQLException {
        try {
            return this.rp.getLastCheckinFailure();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public Throwable getLastCheckoutFailure() throws SQLException {
        try {
            return this.rp.getLastCheckoutFailure();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public Throwable getLastIdleTestFailure() throws SQLException {
        try {
            return this.rp.getLastIdleCheckFailure();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public Throwable getLastConnectionTestFailure() throws SQLException {
        try {
            return this.rp.getLastResourceTestFailure();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public Throwable getLastAcquisitionFailure() throws SQLException {
        try {
            return this.rp.getLastAcquisitionFailure();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, null, e2);
            throw SqlUtils.toSQLException(e2);
        }
    }

    static final class ThrowableHolderPool {
        LinkedList l = new LinkedList();

        ThrowableHolderPool() {
        }

        synchronized Throwable[] getThrowableHolder() {
            if (this.l.size() == 0) {
                return new Throwable[1];
            }
            return (Throwable[])this.l.remove(0);
        }

        synchronized void returnThrowableHolder(Throwable[] th) {
            th[0] = null;
            this.l.add(th);
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        public void connectionClosed(ConnectionEvent evt) {
            this.doCheckinResource(evt);
        }

        private void doCheckinResource(ConnectionEvent evt) {
            try {
                C3P0PooledConnectionPool.this.rp.checkinResource(evt.getSource());
            }
            catch (Exception e2) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", e2);
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            PooledConnection pc;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            int status = (pc = (PooledConnection)evt.getSource()) instanceof C3P0PooledConnection ? ((C3P0PooledConnection)pc).getConnectionStatus() : (pc instanceof NewPooledConnection ? ((NewPooledConnection)pc).getConnectionStatus() : -1);
            int final_status = status;
            this.doMarkPoolStatus(pc, final_status);
        }

        private void doMarkPoolStatus(PooledConnection pc, int status) {
            try {
                switch (status) {
                    case 0: {
                        throw new RuntimeException("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pc);
                        break;
                    }
                    case -8: {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.warning("A ConnectionTest has failed, reporting that all previously acquired Connections are likely invalid. The pool will be reset.");
                        }
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") " + "returned invalid status (" + status + ").");
                    }
                }
            }
            catch (ResourcePoolException e2) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", e2);
            }
        }
    }
}

