/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Comparator;

public final class BeangenUtils {
    public static final Comparator PROPERTY_COMPARATOR = new Comparator(){

        public int compare(Object a2, Object b2) {
            Property aa = (Property)a2;
            Property bb = (Property)b2;
            return String.CASE_INSENSITIVE_ORDER.compare(aa.getName(), bb.getName());
        }
    };

    public static String capitalize(String propName) {
        char c2 = propName.charAt(0);
        return Character.toUpperCase(c2) + propName.substring(1);
    }

    public static void writeExplicitDefaultConstructor(int ctor_modifiers, ClassInfo info, IndentedWriter iw) throws IOException {
        iw.print(CodegenUtils.getModifierString(ctor_modifiers));
        iw.println(' ' + info.getClassName() + "()");
        iw.println("{}");
    }

    public static void writeArgList(Property[] props, boolean declare_types, IndentedWriter iw) throws IOException {
        int len = props.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                iw.print(", ");
            }
            if (declare_types) {
                iw.print(props[i].getSimpleTypeName() + ' ');
            }
            iw.print(props[i].getName());
        }
    }

    public static void writePropertyMember(Property prop, IndentedWriter iw) throws IOException {
        BeangenUtils.writePropertyVariable(prop, iw);
    }

    public static void writePropertyVariable(Property prop, IndentedWriter iw) throws IOException {
        BeangenUtils.writePropertyVariable(prop, prop.getDefaultValueExpression(), iw);
    }

    public static void writePropertyMember(Property prop, String defaultValueExpression, IndentedWriter iw) throws IOException {
        BeangenUtils.writePropertyVariable(prop, defaultValueExpression, iw);
    }

    public static void writePropertyVariable(Property prop, String defaultValueExpression, IndentedWriter iw) throws IOException {
        iw.print(CodegenUtils.getModifierString(prop.getVariableModifiers()));
        iw.print(' ' + prop.getSimpleTypeName() + ' ' + prop.getName());
        String dflt = defaultValueExpression;
        if (dflt != null) {
            iw.print(" = " + dflt);
        }
        iw.println(';');
    }

    public static void writePropertyGetter(Property prop, IndentedWriter iw) throws IOException {
        BeangenUtils.writePropertyGetter(prop, prop.getDefensiveCopyExpression(), iw);
    }

    public static void writePropertyGetter(Property prop, String defensiveCopyExpression, IndentedWriter iw) throws IOException {
        String pfx = "boolean".equals(prop.getSimpleTypeName()) ? "is" : "get";
        iw.print(CodegenUtils.getModifierString(prop.getGetterModifiers()));
        iw.println(' ' + prop.getSimpleTypeName() + ' ' + pfx + BeangenUtils.capitalize(prop.getName()) + "()");
        String retVal = defensiveCopyExpression;
        if (retVal == null) {
            retVal = prop.getName();
        }
        iw.println("{ return " + retVal + "; }");
    }

    public static void writePropertySetter(Property prop, IndentedWriter iw) throws IOException {
        BeangenUtils.writePropertySetter(prop, prop.getDefensiveCopyExpression(), iw);
    }

    public static void writePropertySetter(Property prop, String setterDefensiveCopyExpression, IndentedWriter iw) throws IOException {
        String setVal = setterDefensiveCopyExpression;
        if (setVal == null) {
            setVal = prop.getName();
        }
        String usualGetExpression = "this." + prop.getName();
        String usualSetStatement = "this." + prop.getName() + " = " + setVal + ';';
        BeangenUtils.writePropertySetterWithGetExpressionSetStatement(prop, usualGetExpression, usualSetStatement, iw);
    }

    public static void writePropertySetterWithGetExpressionSetStatement(Property prop, String getExpression, String setStatement, IndentedWriter iw) throws IOException {
        iw.print(CodegenUtils.getModifierString(prop.getSetterModifiers()));
        iw.print(" void set" + BeangenUtils.capitalize(prop.getName()) + "( " + prop.getSimpleTypeName() + ' ' + prop.getName() + " )");
        if (prop.isConstrained()) {
            iw.println(" throws PropertyVetoException");
        } else {
            iw.println();
        }
        iw.println('{');
        iw.upIndent();
        if (BeangenUtils.changeMarked(prop)) {
            String changeCheck;
            iw.println(prop.getSimpleTypeName() + " oldVal = " + getExpression + ';');
            String oldValExpr = "oldVal";
            String newValExpr = prop.getName();
            String simpleTypeName = prop.getSimpleTypeName();
            if (ClassUtils.isPrimitive(simpleTypeName)) {
                Class propType = ClassUtils.classForPrimitive(simpleTypeName);
                if (propType == Byte.TYPE) {
                    oldValExpr = "new Byte( " + oldValExpr + " )";
                    newValExpr = "new Byte( " + newValExpr + " )";
                } else if (propType == Character.TYPE) {
                    oldValExpr = "new Character( " + oldValExpr + " )";
                    newValExpr = "new Character( " + newValExpr + " )";
                } else if (propType == Short.TYPE) {
                    oldValExpr = "new Short( " + oldValExpr + " )";
                    newValExpr = "new Short( " + newValExpr + " )";
                } else if (propType == Float.TYPE) {
                    oldValExpr = "new Float( " + oldValExpr + " )";
                    newValExpr = "new Float( " + newValExpr + " )";
                } else if (propType == Double.TYPE) {
                    oldValExpr = "new Double( " + oldValExpr + " )";
                    newValExpr = "new Double( " + newValExpr + " )";
                }
                changeCheck = "oldVal != " + prop.getName();
            } else {
                changeCheck = "! eqOrBothNull( oldVal, " + prop.getName() + " )";
            }
            if (prop.isConstrained()) {
                iw.println("if ( " + changeCheck + " )");
                iw.upIndent();
                iw.println("vcs.fireVetoableChange( \"" + prop.getName() + "\", " + oldValExpr + ", " + newValExpr + " );");
                iw.downIndent();
            }
            iw.println(setStatement);
            if (prop.isBound()) {
                iw.println("if ( " + changeCheck + " )");
                iw.upIndent();
                iw.println("pcs.firePropertyChange( \"" + prop.getName() + "\", " + oldValExpr + ", " + newValExpr + " );");
                iw.downIndent();
            }
        } else {
            iw.println(setStatement);
        }
        iw.downIndent();
        iw.println('}');
    }

    public static boolean hasBoundProperties(Property[] props) {
        int len = props.length;
        for (int i = 0; i < len; ++i) {
            if (!props[i].isBound()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConstrainedProperties(Property[] props) {
        int len = props.length;
        for (int i = 0; i < len; ++i) {
            if (!props[i].isConstrained()) continue;
            return true;
        }
        return false;
    }

    private static boolean changeMarked(Property prop) {
        return prop.isBound() || prop.isConstrained();
    }

    private BeangenUtils() {
    }
}

