/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ContentLengthUpdater
extends FilterOutputStream {
    private String contentLength;
    private boolean inHeader = true;
    private boolean sawContentLength = false;
    private int lastb1 = -1;
    private int lastb2 = -1;
    private StringBuffer line = new StringBuffer();

    public ContentLengthUpdater(OutputStream os, long contentLength) {
        super(os);
        this.contentLength = "Content-Length: " + contentLength;
    }

    public void write(int b2) throws IOException {
        if (this.inHeader) {
            String eol = "\n";
            if (b2 == 13) {
                if (this.lastb1 == 13) {
                    this.inHeader = false;
                    eol = "\r";
                } else if (this.lastb1 == 10 && this.lastb2 == 13) {
                    this.inHeader = false;
                    eol = "\r\n";
                }
            } else if (b2 == 10 && this.lastb1 == 10) {
                this.inHeader = false;
                eol = "\n";
            }
            if (!this.inHeader && !this.sawContentLength) {
                this.out.write(this.contentLength.getBytes("iso-8859-1"));
                this.out.write(eol.getBytes("iso-8859-1"));
            }
            if (b2 == 13 || b2 == 10 && this.lastb1 != 13) {
                if (this.line.toString().regionMatches(true, 0, "content-length:", 0, 15)) {
                    this.sawContentLength = true;
                    this.out.write(this.contentLength.getBytes("iso-8859-1"));
                } else {
                    this.out.write(this.line.toString().getBytes("iso-8859-1"));
                }
                this.line.setLength(0);
            }
            if (b2 == 13 || b2 == 10) {
                this.out.write(b2);
            } else {
                this.line.append((char)b2);
            }
            this.lastb2 = this.lastb1;
            this.lastb1 = b2;
        } else {
            this.out.write(b2);
        }
    }

    public void write(byte[] b2) throws IOException {
        if (this.inHeader) {
            this.write(b2, 0, b2.length);
        } else {
            this.out.write(b2);
        }
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.inHeader) {
            for (int i = 0; i < len; ++i) {
                this.write(b2[off + i]);
            }
        } else {
            this.out.write(b2, off, len);
        }
    }

    public static void main(String[] argv) throws Exception {
        int b2;
        ContentLengthUpdater os = new ContentLengthUpdater(System.out, Long.parseLong(argv[0]));
        while ((b2 = System.in.read()) >= 0) {
            os.write(b2);
        }
        os.flush();
    }
}

