/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private String fName;

    public TestCase() {
        this.fName = null;
    }

    public TestCase(String name) {
        this.fName = name;
    }

    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public TestResult run() {
        TestResult result = this.createResult();
        this.run(result);
        return result;
    }

    public void run(TestResult result) {
        result.run(this);
    }

    public void runBare() throws Throwable {
        this.setUp();
        try {
            this.runTest();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.tearDown();
            throw throwable;
        }
        Object var1_3 = null;
        this.tearDown();
    }

    protected void runTest() throws Throwable {
        Assert.assertNotNull(this.fName);
        Method runMethod = null;
        try {
            runMethod = this.getClass().getMethod(this.fName, null);
        }
        catch (NoSuchMethodException e2) {
            Assert.fail("Method \"" + this.fName + "\" not found");
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            Assert.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            runMethod.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e3) {
            e3.fillInStackTrace();
            throw e3.getTargetException();
        }
        catch (IllegalAccessException e4) {
            e4.fillInStackTrace();
            throw e4;
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }
}

