/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected String _username = null;
    protected String _password = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcMap = new WeakHashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, ObjectPool pool, String validationQuery, String username, String password) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory(this);
        this._validationQuery = validationQuery;
        this._username = username;
        this._password = password;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(ObjectPool pool) throws SQLException {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new SQLNestedException("Cannot set the pool on this factory", e3);
            }
        }
        this._pool = pool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject() {
        PooledConnectionAndInfo obj;
        try {
            PooledConnection pc = null;
            pc = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            pc.addConnectionEventListener(this);
            obj = new PooledConnectionAndInfo(pc, this._username, this._password);
            this.pcMap.put(pc, obj);
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2.getMessage());
        }
        return obj;
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PooledConnectionAndInfo) {
            ((PooledConnectionAndInfo)obj).getPooledConnection().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateObject(Object obj) {
        boolean valid = false;
        if (obj instanceof PooledConnectionAndInfo) {
            PooledConnection pconn = ((PooledConnectionAndInfo)obj).getPooledConnection();
            String query = this._validationQuery;
            if (null != query) {
                Connection conn = null;
                Statement stmt = null;
                ResultSet rset = null;
                this.validatingMap.put(pconn, null);
                try {
                    conn = pconn.getConnection();
                    stmt = conn.createStatement();
                    rset = stmt.executeQuery(query);
                    if (rset.next()) {
                        valid = true;
                    }
                    valid = false;
                }
                catch (Exception e2) {
                    valid = false;
                }
                finally {
                    try {
                        rset.close();
                    }
                    catch (Throwable t) {}
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {}
                    try {
                        conn.close();
                    }
                    catch (Throwable t) {}
                    this.validatingMap.remove(pconn);
                }
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public void passivateObject(Object obj) {
    }

    public void activateObject(Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        block5: {
            PooledConnection pc = (PooledConnection)event.getSource();
            if (this.validatingMap.containsKey(pc)) break block5;
            Object info = this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(info);
            }
            catch (Exception e2) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                try {
                    this.destroyObject(info);
                }
                catch (Exception e22) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
                    e22.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            if (null != event.getSQLException()) {
                System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
            }
            pc.removeConnectionEventListener(this);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Object info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.destroyObject(info);
        }
        catch (Exception e2) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e2.printStackTrace();
        }
    }
}

