/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.util.HashSet;
import java.util.Set;
import org.eso.cpl.ScriptSyntax;

public class PerlSyntax
implements ScriptSyntax {
    Set vars_ = new HashSet();

    @Override
    public String getName() {
        return "Perl";
    }

    @Override
    public String getExtension() {
        return ".pl";
    }

    @Override
    public String startScript() {
        return "#!/usr/bin/perl -w\nuse strict;\n";
    }

    @Override
    public String blankLine() {
        return "\n";
    }

    @Override
    public String commentLine(String text) {
        return "# " + text + "\n";
    }

    @Override
    public String invokeCommand(String cmd) {
        return "system(\"" + cmd + "\");\n";
    }

    @Override
    public String defineMacro(String name, String value) {
        StringBuffer buf = new StringBuffer(this.declareMy(name));
        buf.append("my $" + name + " = " + value + ";\n");
        return buf.toString();
    }

    @Override
    public String defineMacro(String name, String[] value) {
        StringBuffer buf = new StringBuffer(this.declareMy(name));
        buf.append('$').append(name).append(" = ").append("qq{");
        for (int i = 0; i < value.length; ++i) {
            buf.append("\n   ").append(value[i]);
        }
        buf.append('\n').append("};\n");
        return buf.toString();
    }

    @Override
    public String useMacro(String name) {
        return '$' + name;
    }

    @Override
    public String quoteWord(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        block3: for (int i = 0; i < text.length(); ++i) {
            char c2 = text.charAt(i);
            switch (c2) {
                case '\'': {
                    buf.append('\\').append('\'');
                    continue block3;
                }
                default: {
                    buf.append(c2);
                }
            }
        }
        buf.append('\'');
        return buf.toString();
    }

    @Override
    public String namify(String name) {
        return name.replaceAll("[^a-zA-Z0-9]", "_");
    }

    private String declareMy(String name) {
        String dec;
        if (this.vars_.contains(name)) {
            dec = "";
        } else {
            dec = "my $" + name + ";\n";
            this.vars_.add(name);
        }
        return dec;
    }
}

