/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.eso.cpl.AssociationUtils;
import org.eso.cpl.BourneSyntax;
import org.eso.cpl.CPLException;
import org.eso.cpl.CommandSequence;
import org.eso.cpl.CshSyntax;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameList;
import org.eso.cpl.MarkedFrameList;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.PerlSyntax;
import org.eso.cpl.Recipe;
import org.eso.cpl.Request;
import org.eso.cpl.ScriptSyntax;
import org.eso.cpl.gui.DataColumnTable;
import org.eso.cpl.gui.ErrorDialog;
import org.eso.cpl.gui.ExecutionEvent;
import org.eso.cpl.gui.ExecutionListener;
import org.eso.cpl.gui.ExtensionFileFilter;
import org.eso.cpl.gui.FrameTableModel;
import org.eso.cpl.gui.GUIUtils;
import org.eso.cpl.gui.Icons;
import org.eso.cpl.gui.LogArea;
import org.eso.cpl.gui.RecipeDisplay;
import org.eso.cpl.gui.RequestExecutor;
import org.eso.cpl.gui.RequestItemSelector;
import org.eso.cpl.gui.RequestPanel;
import org.eso.cpl.gui.RequestPool;
import org.eso.cpl.gui.RequestPoolDisplay;
import org.eso.cpl.gui.RequestQueue;
import org.eso.cpl.gui.TableComponentMouseListener;
import org.eso.cpl.jni.CPLControl;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.cpl.jni.MessageListener;
import org.eso.cpl.jni.StreamMessageListener;
import org.eso.dfs.datatransfer.FileListTransferHandler;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.dfs.services.ServiceException;
import org.eso.dfs.services.data.AssociationService;
import org.eso.dfs.services.data.FileAssociationNode;

public class CPLFrame
extends JFrame
implements ExecutionListener {
    private final RequestPanel singlePanel_;
    private final RequestPanel queuedPanel_;
    private final RequestPanel executingPanel_;
    private final JTabbedPane tabber_;
    private final JTable outFrameTable_;
    private final JScrollPane outFrameScroller_;
    private final LogArea logArea_;
    private final JComboBox syntaxChooser_;
    private final RequestPoolDisplay poolDisplay_;
    private PrintWriter errorWriter_;
    private PrintWriter messageWriter_;
    private PrintWriter controlWriter_;
    private PrintWriter commandWriter_;
    private PrintWriter logFileWriter_;
    private static DateFormat dateFormatter_ = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    private final Action executeSingleAction_;
    private final Action executeQueueAction_;
    private final Action enqueueAction_;
    private final Action loadAction_;
    private final Action saveAction_;
    private final Action closeAction_;
    private final Action aboutAction_;
    private final Action clearPanelAction_;
    private final Action logClearAction_;
    private final Action logSaveAction_;
    private final Action outClearAction_;
    private JFileChooser configChooser_;
    private JFileChooser logChooser_;
    private JFileChooser scriptChooser_;
    private RequestPool requestPool_;
    private Recipe recipe_;
    private FrameList outFrames_;
    private LibraryLoader libLoader_;
    private CommandSequence script_;
    private int scriptPos_;
    private RequestExecutor activeExecutor_;
    private int nextQueued_;
    private static final String XmlSuffix = ".xml";
    private String panelName_;
    private static final Cursor BUSY_CURSOR = new Cursor(3);
    private static final String SH_SYNTAX = "Bourne shell";
    private static final String CSH_SYNTAX = "C shell";
    private static final String PERL_SYNTAX = "Perl";

    public CPLFrame(Recipe recipe) {
        this(recipe, null);
    }

    public CPLFrame(Recipe recipe, String name) {
        this(recipe, name, null);
    }

    public CPLFrame(Recipe recipe, String name, String productDirPath) {
        if (name == null) {
            name = recipe == null ? "No Recipe" : recipe.getName();
        }
        this.panelName_ = name;
        this.setTitle(this.panelName_);
        this.recipe_ = recipe;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JSplitPane mainBox = new JSplitPane(0);
        mainBox.setOneTouchExpandable(true);
        Box inputBox = new Box(1);
        Box outputBox = new Box(1);
        mainBox.setTopComponent(inputBox);
        mainBox.setBottomComponent(outputBox);
        contentPane.add((Component)mainBox, "Center");
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        mainBox.setBorder(gapBorder);
        final CPLFrame parent = this;
        this.requestPool_ = new RequestPool();
        this.executeSingleAction_ = new AbstractAction("Execute"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequestQueue q1 = new RequestQueue();
                q1.add(new NamedRequest(CPLFrame.this.singlePanel_.getRequest(), "Current"));
                CPLFrame.this.executeQueue(q1);
            }
        };
        this.executeQueueAction_ = new AbstractAction("Execute Selected"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequestQueue q = CPLFrame.this.requestPool_.getSelectedRequests();
                CPLFrame.this.controlLog("Executing " + q.size() + "-element queue");
                CPLFrame.this.executeQueue(q);
            }
        };
        this.enqueueAction_ = new AbstractAction("Add to pool"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPLFrame.this.enqueueRequest(new NamedRequest(CPLFrame.this.singlePanel_.getRequest(), CPLFrame.this.nextQueuedRequestName()));
            }
        };
        this.loadAction_ = new AbstractAction("Load Current Settings"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Exception error;
                try {
                    Request req = CPLFrame.this.loadConfiguration(CPLFrame.this.singlePanel_.getRequest());
                    if (req != null) {
                        CPLFrame.this.setSingleRequest(new NamedRequest(req, "Current"));
                        CPLFrame.this.showRequestPanel(CPLFrame.this.singlePanel_);
                    }
                    error = null;
                }
                catch (IOException e2) {
                    error = e2;
                }
                catch (CPLException e3) {
                    error = e3;
                }
                catch (ParameterValueException e4) {
                    error = e4;
                }
                if (error != null) {
                    ErrorDialog.showError(error, "Error loading config file", parent);
                }
            }
        };
        this.saveAction_ = new AbstractAction("Save Current Settings"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOException error;
                try {
                    CPLFrame.this.saveConfiguration(CPLFrame.this.singlePanel_.getRequest());
                    error = null;
                }
                catch (IOException e2) {
                    error = e2;
                }
                if (error != null) {
                    ErrorDialog.showError(error, "Error saving config file", parent);
                }
            }
        };
        this.clearPanelAction_ = new AbstractAction("Clear Current"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (JOptionPane.showConfirmDialog(CPLFrame.this, "Are you sure you want to clear all frames and logs?", "Clear Recipe Panel", 0) == 0) {
                    CPLFrame.this.clearPanel();
                }
            }
        };
        this.closeAction_ = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPLFrame.this.dispose();
            }
        };
        this.aboutAction_ = new AbstractAction("About"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final JDialog frame = new JDialog(CPLFrame.this, CPLFrame.this.panelName_, false);
                JPanel pan = new JPanel(new BorderLayout());
                RecipeDisplay rdisp = new RecipeDisplay();
                rdisp.setRecipe(CPLFrame.this.getRecipe());
                pan.add((Component)rdisp, "Center");
                frame.setTitle(CPLFrame.this.panelName_);
                frame.getContentPane().add(pan);
                frame.pack();
                frame.setLocationRelativeTo(CPLFrame.this);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e2) {
                        frame.dispose();
                    }
                });
                frame.setVisible(true);
            }
        };
        this.logClearAction_ = new AbstractAction("Clear Messages"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPLFrame.this.clearLogMessages();
            }
        };
        this.logSaveAction_ = new AbstractAction("Save Messages"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser saver = CPLFrame.this.getLogSaver();
                if (saver.showSaveDialog(parent) == 0) {
                    try {
                        CPLFrame.writeDocument(CPLFrame.this.logArea_.getDocument(), saver.getSelectedFile());
                    }
                    catch (IOException e2) {
                        ErrorDialog.showError(e2, "Error writing log file", parent);
                    }
                }
            }
        };
        this.outClearAction_ = new AbstractAction("Clear Output Frames"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPLFrame.this.clearOutputFrames();
            }
        };
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        JMenu fileMenu = new JMenu("File");
        mbar.add(fileMenu);
        fileMenu.add(this.saveAction_);
        fileMenu.add(this.loadAction_);
        fileMenu.add(this.clearPanelAction_);
        fileMenu.add(this.closeAction_);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(this.aboutAction_);
        mbar.add(helpMenu);
        this.syntaxChooser_ = new JComboBox<String>(new String[]{SH_SYNTAX, CSH_SYNTAX, PERL_SYNTAX});
        this.syntaxChooser_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    CPLFrame.this.initScript();
                }
            }
        });
        this.syntaxChooser_.setSelectedItem(SH_SYNTAX);
        this.syntaxChooser_.revalidate();
        Box inBox = new Box(0);
        inputBox.add(inBox);
        this.singlePanel_ = new RequestPanel(productDirPath);
        this.queuedPanel_ = new RequestPanel(productDirPath);
        this.executingPanel_ = new RequestPanel(productDirPath);
        this.executingPanel_.setLocked(true);
        this.tabber_ = new JTabbedPane(1);
        this.tabber_.add("Current", this.singlePanel_);
        this.tabber_.add("Queued", this.queuedPanel_);
        this.tabber_.add("Executing", this.executingPanel_);
        this.showRequestPanel(this.singlePanel_);
        this.tabber_.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.tabber_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CPLFrame.this.configureAvailableActions();
            }
        });
        JPanel singleBox = new JPanel(new BorderLayout());
        Box smid = new Box(0);
        Box sbot = new Box(0);
        singleBox.add((Component)sbot, "South");
        singleBox.add((Component)smid, "Center");
        smid.add(this.tabber_);
        sbot.add(Box.createHorizontalGlue());
        sbot.add(CPLFrame.center(new JLabel(Icons.ARROW_SE)));
        sbot.add(Box.createHorizontalStrut(5));
        sbot.add(CPLFrame.center(new JButton(this.executeSingleAction_)));
        sbot.add(Box.createHorizontalStrut(5));
        sbot.add(CPLFrame.center(new JLabel(Icons.ARROW_ES)));
        sbot.add(Box.createHorizontalGlue());
        inBox.add(singleBox);
        JPanel queueBox = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width, super.getMaximumSize().height);
            }
        };
        Box qtop = new Box(1);
        Box qmid = new Box(1);
        Box qbot = new Box(1);
        queueBox.add((Component)qtop, "North");
        queueBox.add((Component)qmid, "Center");
        queueBox.add((Component)qbot, "South");
        this.poolDisplay_ = new RequestPoolDisplay(this.requestPool_);
        this.poolDisplay_.setSelectionMode(2);
        JScrollPane qscroller = this.poolDisplay_.wrapInScroller();
        GUIUtils.wrapInBorder(qscroller, "Request Pool");
        qtop.add(Box.createVerticalStrut(32));
        qtop.add(CPLFrame.wrapIcon(Icons.ARROW_EES));
        JButton enqueueButton = new JButton(this.enqueueAction_);
        qscroller.setTransferHandler(this.getFileListDropHandler());
        qtop.add(CPLFrame.center(enqueueButton));
        qtop.add(CPLFrame.wrapIcon(Icons.ARROW_S));
        qmid.add(CPLFrame.center(qscroller));
        qbot.add(CPLFrame.wrapIcon(Icons.ARROW_S));
        qbot.add(CPLFrame.center(new JButton(this.executeQueueAction_)));
        qbot.add(CPLFrame.wrapIcon(Icons.ARROW_S));
        inBox.add(queueBox);
        this.outFrameTable_ = new DataColumnTable();
        GUIUtils.configureTable(this.outFrameTable_);
        GUIUtils.enableFileListDragDrop(this.outFrameTable_);
        this.outFrameTable_.addMouseListener(new TableComponentMouseListener());
        this.outFrameScroller_ = GUIUtils.wrapInScroller(this.outFrameTable_);
        Box outBox = new Box(1);
        Box outControlBox = new Box(0);
        outBox.add(outControlBox);
        outBox.add(Box.createVerticalStrut(5));
        outBox.add(this.outFrameScroller_);
        outputBox.add(GUIUtils.wrapInBorder(outBox, "Output Frames"));
        outControlBox.add(Box.createHorizontalGlue());
        JButton outClearButton = new JButton(this.outClearAction_);
        outClearButton.setText("Clear");
        outControlBox.add(outClearButton);
        outputBox.add(Box.createVerticalStrut(5));
        this.logArea_ = new LogArea();
        Box logBox = new Box(1);
        Box logControlBox = new Box(0);
        logBox.add(logControlBox);
        logBox.add(Box.createVerticalStrut(5));
        logBox.add(GUIUtils.wrapInScroller(this.logArea_));
        outputBox.add(GUIUtils.wrapInBorder(logBox, "Log Messages"));
        JButton logSaveButton = new JButton(this.logSaveAction_);
        JButton logClearButton = new JButton(this.logClearAction_);
        logSaveButton.setText("Save");
        logClearButton.setText("Clear");
        logControlBox.add(Box.createHorizontalGlue());
        logControlBox.add(logSaveButton);
        logControlBox.add(Box.createHorizontalStrut(5));
        logControlBox.add(logClearButton);
        this.messageWriter_ = new PrintWriter(new TextAreaWriter(this.logArea_, "message"));
        this.controlWriter_ = new PrintWriter(new TextAreaWriter(this.logArea_, "control"));
        this.errorWriter_ = new PrintWriter(new TextAreaWriter(this.logArea_, "error"));
        this.commandWriter_ = new PrintWriter(new TextAreaWriter(this.logArea_, "command"));
        this.requestPool_.items_.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent evt) {
            }

            @Override
            public void intervalAdded(ListDataEvent evt) {
                CPLFrame.this.configureAvailableActions();
            }

            @Override
            public void intervalRemoved(ListDataEvent evt) {
                CPLFrame.this.configureAvailableActions();
            }
        });
        this.poolDisplay_.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting() && CPLFrame.this.activeExecutor_ == null) {
                    Object[] selected = CPLFrame.this.poolDisplay_.getSelectedValues();
                    if (selected.length == 1) {
                        Request request = (Request)selected[0];
                        if (request != CPLFrame.this.queuedPanel_.getRequest()) {
                            CPLFrame.this.queuedPanel_.setRequest((Request)selected[0]);
                            CPLFrame.this.showRequestPanel(CPLFrame.this.queuedPanel_);
                        }
                    } else {
                        CPLFrame.this.showRequestPanel(CPLFrame.this.singlePanel_);
                    }
                    CPLFrame.this.configureAvailableActions();
                }
            }
        });
        this.initScript();
        this.configureAvailableActions();
        this.pack();
    }

    public Recipe getRecipe() {
        return this.recipe_;
    }

    private void setOutputFrames(FrameList outFrames) {
        this.outFrames_ = outFrames;
        FrameList flist = outFrames == null ? new FrameList() : outFrames;
        this.outFrameTable_.setModel(new FrameTableModel(flist, false));
        JScrollBar vbar = this.outFrameScroller_.getVerticalScrollBar();
        vbar.setValue(vbar.getMaximum());
    }

    public FrameList getOutputFrames() {
        return this.outFrames_;
    }

    public void setLibraryLoader(LibraryLoader libLoader) {
        this.libLoader_ = libLoader;
    }

    public LibraryLoader getLibraryLoader() {
        return this.libLoader_;
    }

    public boolean setSingleRequest(Request req) {
        boolean rc;
        Recipe recipe = req.getRecipe();
        if (!req.getRecipe().equals(this.getRecipe())) {
            rc = false;
        } else {
            this.singlePanel_.setRequest(req);
            rc = true;
        }
        return rc;
    }

    public void enqueueRequest(Request req) {
        if (!req.getRecipe().equals(this.getRecipe())) {
            boolean rc = false;
        } else {
            this.requestPool_.add(req);
            boolean rc = true;
        }
    }

    private boolean enqueueRequest(Request req, FrameList addFrames) {
        boolean rc;
        if (!req.getRecipe().equals(this.getRecipe())) {
            rc = false;
        } else {
            req.getInputFrames().addAll(addFrames);
            this.requestPool_.add(req);
            rc = true;
        }
        return rc;
    }

    private List getFrameGroups(List files) {
        ArrayList rc = new ArrayList();
        return rc;
    }

    public void executeQueue(final RequestQueue queue) {
        final RequestExecutor rex = new RequestExecutor();
        rex.addExecutionListener(this);
        final LogAreaMessageListener msgListener = new LogAreaMessageListener();
        Thread runner = new Thread(){

            @Override
            public void run() {
                CPLFrame.this.setBusyLater(true);
                CPLControl.addMessageListener(msgListener);
                while (CPLFrame.this.activeExecutor_ == rex && queue.hasNext()) {
                    final Request req = queue.next();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CPLFrame.this.executingPanel_.setRequest(req);
                        }
                    });
                    rex.execute(req);
                }
                CPLControl.removeMessageListener(msgListener);
                if (CPLFrame.this.activeExecutor_ == rex) {
                    CPLFrame.this.setActiveExecutor(null);
                    CPLFrame.this.setBusyLater(false);
                    if (CPLFrame.this.getShownRequestPanel() == CPLFrame.this.executingPanel_) {
                        final RequestPanel rp = queue == CPLFrame.this.requestPool_ && queue.hasNext() ? CPLFrame.this.queuedPanel_ : CPLFrame.this.singlePanel_;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CPLFrame.this.showRequestPanel(rp);
                            }
                        });
                    }
                }
            }
        };
        this.setActiveExecutor(rex);
        this.showRequestPanel(this.executingPanel_);
        runner.start();
    }

    @Override
    public void executionStarted(ExecutionEvent evt) {
        Request request = evt.getRequest();
        this.controlLog("Executing request: " + request);
        NamingScheme namer = request.getNamingScheme();
        String logFileName = request.getRecipe().getName() + "_" + dateFormatter_.format(new Date()) + ".log";
        File log = new File(request.getProductRoot().getAbsolutePath() + File.separator + logFileName);
        if (log.exists() && !log.delete()) {
            this.errorLog("Error (1) creating execution log file : " + log.getPath());
            log = null;
        } else {
            try {
                if (!log.createNewFile()) {
                    this.errorLog("Error (2) creating execution log file: " + log.getPath());
                    log = null;
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
                this.errorLog("Error (3) creating execution log file: " + log.getPath());
                log = null;
            }
        }
        if (log != null) {
            try {
                FileWriter logWriter = new FileWriter(log);
                this.logFileWriter_ = new PrintWriter(new BufferedWriter(logWriter));
            }
            catch (IOException e3) {
                this.errorLog("Error opening execution log file: " + log.getPath());
            }
        }
        request.appendToScript(this.script_);
        StringBuffer sbuf = this.script_.getBuffer();
        this.commandLog(request.toReportString());
        this.scriptPos_ = sbuf.length();
    }

    @Override
    public void executionEnded(ExecutionEvent evt) {
        FrameList outFrames0 = this.getOutputFrames();
        if (outFrames0 == null) {
            outFrames0 = new FrameList();
        }
        FrameList outFrames1 = evt.getOutputFrames();
        ArrayList<File> newProductFiles = new ArrayList<File>();
        if (outFrames1 != null) {
            if (outFrames1.size() > 0) {
                this.controlLog("Product frames:");
            }
            for (Frame frm : outFrames1) {
                this.controlLog("   " + frm.getFile());
                if (outFrames0.contains(frm)) {
                    outFrames0.remove(frm);
                }
                newProductFiles.add(frm.getFile());
                outFrames0.add(frm);
            }
        }
        File[] newFiles = new File[newProductFiles.size()];
        newProductFiles.toArray(newFiles);
        try {
            for (int i = 0; i < newFiles.length; ++i) {
                newFiles[i] = newFiles[i].getCanonicalFile();
            }
            AssociationService.getInstance().addFiles(newFiles);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.errorLog("Error reading product files: " + e2.getMessage());
        }
        catch (ServiceException e3) {
            e3.printStackTrace();
            this.errorLog("Error adding files to data model: " + e3.getMessage());
        }
        this.setOutputFrames(outFrames0);
        this.controlLog("Completion status: " + evt.getStatus());
        Throwable error = evt.getError();
        if (error != null) {
            if (error instanceof CPLException) {
                this.errorLog("Execution error: " + error.getMessage());
                Throwable cause = error.getCause();
                if (cause != null) {
                    StringWriter wr = new StringWriter();
                    cause.printStackTrace(new PrintWriter(wr));
                    this.errorLog("caused by\n" + wr.toString());
                }
            } else {
                StringWriter wr = new StringWriter();
                error.printStackTrace(new PrintWriter(wr));
                this.errorLog("caused by\n" + wr.toString());
                this.errorLog(wr.toString());
            }
        }
        this.logFileWriter_.flush();
        this.logFileWriter_.close();
        this.logFileWriter_ = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CPLFrame.this.poolDisplay_.repaint();
            }
        });
    }

    private void setActiveExecutor(RequestExecutor ex) {
        this.activeExecutor_ = ex;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CPLFrame.this.configureAvailableActions();
            }
        });
    }

    private void configureAvailableActions() {
        boolean isExecuting = this.activeExecutor_ != null;
        boolean singleShowing = this.singlePanel_.equals(this.tabber_.getSelectedComponent());
        boolean hasQueue = this.requestPool_.getNumberSelectedRequests() > 0;
        boolean isSelected = this.poolDisplay_.getSelectedIndices().length == 1;
        this.executeQueueAction_.setEnabled(hasQueue && !isExecuting);
        this.executeSingleAction_.setEnabled(singleShowing && !isExecuting);
        this.singlePanel_.setLocked(isExecuting);
        this.queuedPanel_.setLocked(isExecuting);
        this.enqueueAction_.setEnabled(singleShowing);
        this.tabber_.setEnabledAt(this.tabber_.indexOfComponent(this.queuedPanel_), isSelected);
        this.tabber_.setEnabledAt(this.tabber_.indexOfComponent(this.executingPanel_), isExecuting);
        this.loadAction_.setEnabled(singleShowing);
        this.saveAction_.setEnabled(singleShowing);
        this.clearPanelAction_.setEnabled(singleShowing);
    }

    private JFileChooser getConfigSaver() {
        if (this.configChooser_ == null) {
            this.configChooser_ = new SwingFileChooser();
            ExtensionFileFilter xmlFilter = new ExtensionFileFilter(XmlSuffix, "XML files");
            this.configChooser_.setFileFilter(xmlFilter);
        }
        return this.configChooser_;
    }

    private JFileChooser getConfigLoader() {
        return this.getConfigSaver();
    }

    private JFileChooser getLogSaver() {
        if (this.logChooser_ == null) {
            this.logChooser_ = new SwingFileChooser();
            ExtensionFileFilter logFilter = new ExtensionFileFilter(".log", "Log files");
            this.logChooser_.setFileFilter(logFilter);
        }
        return this.logChooser_;
    }

    private JFileChooser getScriptSaver(CommandSequence script) {
        if (this.scriptChooser_ == null) {
            this.scriptChooser_ = new SwingFileChooser();
        }
        this.scriptChooser_.setFileFilter(this.script_.getFileFilter());
        return this.scriptChooser_;
    }

    public void clearLogMessages() {
        this.logArea_.clear();
        this.initScript();
    }

    public void clearOutputFrames() {
        this.setOutputFrames(new FrameList());
    }

    public void clearInputFrames() {
        Request req = this.singlePanel_.getRequest();
        req.getInputFrames().clear();
        this.setSingleRequest(req);
    }

    public void clearPanel() {
        this.clearLogMessages();
        this.clearInputFrames();
        this.clearOutputFrames();
    }

    private void initScript() {
        Object sname = this.syntaxChooser_.getSelectedItem();
        ScriptSyntax syntax = sname.equals(CSH_SYNTAX) ? new CshSyntax() : (sname.equals(PERL_SYNTAX) ? new PerlSyntax() : new BourneSyntax());
        this.script_ = new CommandSequence(syntax);
        this.scriptPos_ = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request loadConfiguration(Request template) throws IOException, CPLException, ParameterValueException {
        block13: {
            JFileChooser loader = this.getConfigLoader();
            int result = loader.showDialog(this, "Load Configuration");
            if (result == 0) {
                File file = loader.getSelectedFile();
                if (file.exists()) {
                    FileInputStream istrm = new FileInputStream(file);
                    try {
                        String[] msg;
                        int sret;
                        String[] msg2;
                        Request request = new Request(istrm, this.getLibraryLoader());
                        boolean sameRecipe = request.getRecipe().equals(this.getRecipe());
                        if (!sameRecipe && JOptionPane.showConfirmDialog(this, msg2 = new String[]{"The selected file contain a different recipe, (" + request.getRecipe().getName() + " v" + request.getRecipe().getVersion() + ")", "The recipe and parameters will be ignored when loading.", "Do you wish to continue?"}, "Load Settings", 2, 3) == 2) {
                            Request request2 = null;
                            return request2;
                        }
                        Recipe recipe = request.getRecipe();
                        Parameter[] params = recipe != null ? request.getParameters() : null;
                        MarkedFrameList frames = request.getInputFrames();
                        RequestItemSelector select = new RequestItemSelector();
                        select.parametersBox_.setSelected(sameRecipe && params != null);
                        select.parametersBox_.setEnabled(sameRecipe && params != null);
                        if (frames == null) {
                            select.calibFramesBox_.setSelected(false);
                            select.calibFramesBox_.setEnabled(false);
                            select.rawFramesBox_.setSelected(false);
                            select.rawFramesBox_.setEnabled(false);
                        }
                        if ((sret = select.showDialog(this, "Load Settings", msg = new String[]{"Choose the items you wish to load", "from the selected file"})) == 0) {
                            MarkedFrameList frames1;
                            Parameter[] params1;
                            boolean useRecipe = false;
                            boolean useParams = select.parametersBox_.isSelected();
                            boolean useCalib = select.calibFramesBox_.isSelected();
                            boolean useRaw = select.rawFramesBox_.isSelected();
                            boolean useRoot = select.productRootBox_.isSelected();
                            boolean useNaming = select.namingSchemeBox_.isSelected();
                            Recipe recipe1 = template.getRecipe();
                            Parameter[] parameterArray = params1 = useParams ? request.getParameters() : template.getParameters();
                            if (useCalib || useRaw) {
                                frames1 = new MarkedFrameList();
                                if (useCalib) {
                                    frames1.addAll(frames.selectByGroup(FrameGroup.CALIB));
                                }
                                if (useRaw) {
                                    frames1.addAll(frames.selectByGroup(FrameGroup.RAW));
                                }
                            } else {
                                frames1 = template.getInputFrames();
                            }
                            File root1 = useRoot ? request.getProductRoot() : template.getProductRoot();
                            NamingScheme namer1 = useNaming ? request.getNamingScheme() : template.getNamingScheme();
                            Request request3 = new Request(recipe1, params1, frames1, root1, namer1);
                            return request3;
                        }
                        break block13;
                    }
                    finally {
                        ((InputStream)istrm).close();
                    }
                }
                throw new FileNotFoundException("No such file: " + file);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfiguration(Request request) throws IOException {
        JFileChooser saver = this.getConfigSaver();
        int result = saver.showDialog(this, "Save Configuration");
        if (result == 0) {
            RequestItemSelector select = new RequestItemSelector();
            if (request.getInputFrames() == null) {
                select.calibFramesBox_.setSelected(false);
                select.calibFramesBox_.setEnabled(false);
                select.rawFramesBox_.setSelected(false);
                select.rawFramesBox_.setEnabled(false);
            } else {
                MarkedFrameList frames = request.getInputFrames();
                FrameList raw = frames.selectByGroup(FrameGroup.RAW);
                FrameList calib = frames.selectByGroup(FrameGroup.CALIB);
                if (raw.size() == 0) {
                    select.rawFramesBox_.setSelected(false);
                    select.rawFramesBox_.setEnabled(false);
                }
                if (calib.size() == 0) {
                    select.calibFramesBox_.setSelected(false);
                    select.calibFramesBox_.setEnabled(false);
                }
            }
            String[] msg = new String[]{"Choose the items you wish to save", "to the selected configuration file"};
            int sret = select.showDialog(this, "Save options", msg);
            if (sret == 0) {
                boolean useRecipe = true;
                boolean useParams = select.parametersBox_.isSelected();
                boolean useCalib = select.calibFramesBox_.isSelected();
                boolean useRaw = select.rawFramesBox_.isSelected();
                boolean useRoot = select.productRootBox_.isSelected();
                boolean useNaming = select.namingSchemeBox_.isSelected();
                MarkedFrameList frames = new MarkedFrameList();
                if (useCalib || useRaw) {
                    MarkedFrameList frms = request.getInputFrames();
                    if (useCalib) {
                        frames.addAll(frms.selectByGroup(FrameGroup.CALIB));
                    }
                    if (useRaw) {
                        frames.addAll(frms.selectByGroup(FrameGroup.RAW));
                    }
                }
                Request req1 = new Request(useRecipe ? request.getRecipe() : null, useParams ? request.getParameters() : null, frames, useRoot ? request.getProductRoot() : null, useNaming ? request.getNamingScheme() : null);
                File file = saver.getSelectedFile();
                if (!file.getName().endsWith(XmlSuffix)) {
                    file = new File(file.getAbsolutePath() + XmlSuffix);
                }
                FileOutputStream ostrm = new FileOutputStream(file);
                try {
                    req1.write(ostrm);
                }
                finally {
                    ((OutputStream)ostrm).close();
                }
            }
        }
    }

    private void setBusy(boolean isBusy) {
        this.setCursor(isBusy ? BUSY_CURSOR : null);
    }

    private void setBusyLater(final boolean isBusy) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CPLFrame.this.setBusy(isBusy);
            }
        });
    }

    private void showRequestPanel(RequestPanel panel) {
        this.tabber_.setSelectedComponent(panel);
        this.tabber_.setEnabled(panel != this.executingPanel_);
    }

    private RequestPanel getShownRequestPanel() {
        return (RequestPanel)this.tabber_.getSelectedComponent();
    }

    private String nextQueuedRequestName() {
        return "Request " + ++this.nextQueued_;
    }

    private static JComponent center(JComponent comp) {
        comp.setAlignmentX(0.5f);
        comp.setAlignmentY(0.5f);
        return comp;
    }

    private static JComponent wrapIcon(Icon icon) {
        JLabel label = new JLabel(icon);
        label.setAlignmentX(0.5f);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return label;
    }

    public void controlLog(String msg) {
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        this.controlWriter_.print(msg);
        this.controlWriter_.flush();
        if (this.logFileWriter_ != null) {
            this.logFileWriter_.print(msg);
            this.logFileWriter_.flush();
        }
    }

    public void messageLog(String msg) {
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        System.out.println(msg);
        this.messageWriter_.print(msg);
        this.messageWriter_.flush();
        if (this.logFileWriter_ != null) {
            this.logFileWriter_.print(msg);
            this.logFileWriter_.flush();
        }
    }

    public void errorLog(String msg) {
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        System.out.println(msg);
        this.errorWriter_.print(msg);
        this.errorWriter_.flush();
        if (this.logFileWriter_ != null) {
            this.logFileWriter_.print(msg);
            this.logFileWriter_.flush();
        }
    }

    public void commandLog(String msg) {
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        System.out.println(msg);
        this.commandWriter_.print(msg);
        this.commandWriter_.flush();
        if (this.logFileWriter_ != null) {
            this.logFileWriter_.print(msg);
            this.logFileWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDocument(Document doc, File file) throws IOException {
        Writer writer = null;
        try {
            writer = new FileWriter(file);
            writer = new BufferedWriter(writer);
            int nleft = doc.getLength();
            Segment text = new Segment();
            text.setPartialReturn(true);
            int offs = 0;
            while (nleft > 0) {
                try {
                    doc.getText(offs, nleft, text);
                }
                catch (BadLocationException e2) {
                    throw (IOException)new IOException(e2.getMessage()).initCause(e2);
                }
                char c2 = text.first();
                while (c2 != '\uffff') {
                    writer.write(c2);
                    c2 = text.next();
                }
                nleft -= text.count;
                offs += text.count;
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private TransferHandler getFileListDropHandler() {
        return new FileListTransferHandler(){

            @Override
            protected List exportFileList(JComponent arg0) {
                return null;
            }

            @Override
            protected void importFileList(JComponent arg0, List files) {
                CPLFrame.this.addInputFramesToQueue(files);
            }
        };
    }

    public void addInputFramesToQueue(FrameList input) {
        ArrayList<File> files = new ArrayList<File>();
        Iterator fileIter = input.iterator();
        while (fileIter.hasNext()) {
            files.add(((Frame)fileIter.next()).getFile());
        }
        this.addInputFramesToQueue(files);
    }

    public void addInputFramesToQueue(List files) {
        FileAssociationNode[] nodes = AssociationUtils.classifyFiles(files);
        HashMap<String, FrameList> groups = new HashMap<String, FrameList>();
        for (int i = 0; i < nodes.length; ++i) {
            Frame frm = AssociationUtils.getFrameFromNode(nodes[i]);
            if (frm.getTag() == null) continue;
            String groupName = nodes[i].getGrouping()[0];
            FrameList group = (FrameList)groups.get(groupName);
            if (group == null) {
                group = new FrameList();
                groups.put(groupName, group);
            }
            group.add(frm);
        }
        Iterator groupI = groups.values().iterator();
        while (groupI.hasNext()) {
            this.enqueueRequest(new NamedRequest(this.singlePanel_.getRequest(), this.nextQueuedRequestName()), (FrameList)groupI.next());
        }
    }

    public void addInputFramesToShownRequest(FrameList input) {
        RequestPanel p = this.getShownRequestPanel();
        if (p != this.executingPanel_) {
            p.addInputFrames(input);
        }
    }

    public String getPanelName() {
        return this.panelName_;
    }

    private static class NamedRequest
    extends Request {
        final String name_;

        public NamedRequest(Request req, String name) {
            super(req);
            this.name_ = name;
        }

        public String toString() {
            return this.name_;
        }
    }

    private static class TextAreaWriter
    extends Writer {
        private LogArea target_;
        private String style_;

        public TextAreaWriter(LogArea target, String style) {
            this.target_ = target;
            this.style_ = style;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.target_.append(new String(cbuf, off, len), this.style_);
            this.moveToEnd();
        }

        @Override
        public void write(String str) {
            this.target_.appendMessage(str);
            this.moveToEnd();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        private void moveToEnd() {
            this.target_.setCaretPosition(this.target_.getDocument().getLength());
        }
    }

    private class LogAreaMessageListener
    implements MessageListener {
        private LogAreaMessageListener() {
        }

        private String terminate(String msg) {
            return msg.charAt(msg.length() - 1) == '\n' ? msg : msg + '\n';
        }

        @Override
        public void errMessage(String msg) {
            CPLFrame.this.errorLog(this.terminate("ERROR: " + msg));
        }

        @Override
        public void outMessage(String msg) {
            CPLFrame.this.messageLog(this.terminate(msg));
        }

        @Override
        public void logMessage(String domain, String msg, int flags) {
            this.outMessage(StreamMessageListener.formatMessage(domain, msg, flags));
        }
    }
}

