/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;
import org.eso.cpl.gui.DataColumn;
import org.eso.cpl.gui.DataColumnTableModel;
import org.eso.cpl.gui.Renderers;
import org.eso.dfs.services.ServiceException;
import org.eso.dfs.services.gui.FileImageDisplayService;

public class FrameTableModel
extends DataColumnTableModel {
    private final FrameList frames_;
    private Map displayButtons_ = new HashMap();
    private Map locateButtons_ = new HashMap();

    public FrameTableModel(FrameList frames, boolean isEditable) {
        this.frames_ = frames;
        final TableCellEditor groupEditor = Renderers.getOptionEditor(FrameGroup.ALL_GROUPS);
        final TableCellEditor levelEditor = Renderers.getOptionEditor(FrameLevel.ALL_LEVELS);
        final TableCellEditor typeEditor = Renderers.getOptionEditor(FrameType.ALL_TYPES);
        final TableCellEditor filenameEditor = Renderers.getTrailingStringEditor();
        final TableCellRenderer filenameRenderer = Renderers.getTrailingStringRenderer();
        final TableCellRenderer buttRenderer = Renderers.getComponentRenderer();
        DataColumn filenameColumn = new DataColumn("Filename", false, 200){

            @Override
            public Object getValue(int irow) {
                return FrameTableModel.this.getFrame(irow).getFile().getName();
            }

            @Override
            public void setValue(int irow, Object value) {
                FrameTableModel.this.getFrame(irow).setFile(new File((String)value));
            }

            @Override
            public TableCellRenderer getCellRenderer(int irow) {
                return filenameRenderer;
            }

            @Override
            public TableCellEditor getCellEditor(int irow) {
                return filenameEditor;
            }

            @Override
            public String getRendererTip(int irow) {
                return FrameTableModel.this.getFrame(irow).getCanonicalPath();
            }
        };
        DataColumn groupColumn = new DataColumn("Group", isEditable, 15){

            @Override
            public Object getValue(int irow) {
                return FrameTableModel.this.getFrame(irow).getGroup();
            }

            @Override
            public void setValue(int irow, Object value) {
                FrameTableModel.this.getFrame(irow).setGroup((FrameGroup)value);
            }

            @Override
            public TableCellEditor getCellEditor(int irow) {
                return groupEditor;
            }

            @Override
            public String getRendererTip(int irow) {
                return FrameTableModel.this.getFrame(irow).getCanonicalPath();
            }
        };
        DataColumn levelColumn = new DataColumn("Level", isEditable){

            @Override
            public Object getValue(int irow) {
                return FrameTableModel.this.getFrame(irow).getLevel();
            }

            @Override
            public void setValue(int irow, Object value) {
                FrameTableModel.this.getFrame(irow).setLevel((FrameLevel)value);
            }

            @Override
            public TableCellEditor getCellEditor(int irow) {
                return levelEditor;
            }

            @Override
            public String getRendererTip(int irow) {
                return FrameTableModel.this.getFrame(irow).getCanonicalPath();
            }
        };
        DataColumn tagColumn = new DataColumn("Classification", isEditable, String.class){

            @Override
            public Object getValue(int irow) {
                return FrameTableModel.this.getFrame(irow).getTag();
            }

            @Override
            public void setValue(int irow, Object value) {
                FrameTableModel.this.getFrame(irow).setTag((String)value);
            }

            @Override
            public String getRendererTip(int irow) {
                return FrameTableModel.this.getFrame(irow).getCanonicalPath();
            }
        };
        DataColumn typeColumn = new DataColumn("Type", isEditable){

            @Override
            public Object getValue(int irow) {
                return FrameTableModel.this.getFrame(irow).getType();
            }

            @Override
            public void setValue(int irow, Object value) {
                FrameTableModel.this.getFrame(irow).setType((FrameType)value);
            }

            @Override
            public TableCellEditor getCellEditor(int irow) {
                return typeEditor;
            }

            @Override
            public String getRendererTip(int irow) {
                return FrameTableModel.this.getFrame(irow).getCanonicalPath();
            }
        };
        DataColumn optionsColumn1 = new DataColumn("", true){
            TableCellEditor editor;
            {
                super(x0, x1);
                this.editor = Renderers.getComponentEditor();
            }

            @Override
            public Object getValue(int irow) {
                return FrameTableModel.this.getDisplayButton(FrameTableModel.this.getFrame(irow), false);
            }

            @Override
            public TableCellRenderer getCellRenderer(int irow) {
                return buttRenderer;
            }

            @Override
            public TableCellEditor getCellEditor(int irow) {
                return this.editor;
            }

            @Override
            public String getRendererTip(int irow) {
                return "Locate file in Gasgano";
            }
        };
        DataColumn optionsColumn2 = new DataColumn("", true){
            TableCellEditor editor;
            {
                super(x0, x1);
                this.editor = Renderers.getComponentEditor();
            }

            @Override
            public Object getValue(int irow) {
                return FrameTableModel.this.getDisplayButton(FrameTableModel.this.getFrame(irow), true);
            }

            @Override
            public TableCellRenderer getCellRenderer(int irow) {
                return buttRenderer;
            }

            @Override
            public TableCellEditor getCellEditor(int irow) {
                return this.editor;
            }

            @Override
            public String getRendererTip(int irow) {
                return "Send file to external viewer";
            }
        };
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        columns.add(filenameColumn);
        columns.add(tagColumn);
        columns.add(optionsColumn1);
        columns.add(optionsColumn2);
        this.setDataColumns(columns);
    }

    @Override
    public int getRowCount() {
        return this.frames_.size();
    }

    public Frame getFrame(int irow) {
        return this.frames_.getFrame(irow);
    }

    public FrameList getFrames() {
        return this.frames_;
    }

    private Component createOptionButton(final Frame frm, final boolean showImage) {
        final String tag = showImage ? "Display" : "Locate";
        AbstractAction action = new AbstractAction(tag){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.out.println(tag + " frame " + frm.getCanonicalPath());
                try {
                    FileImageDisplayService.getInstance().displayFile(new String[]{frm.getCanonicalPath()}, showImage);
                }
                catch (ServiceException e2) {
                    e2.printStackTrace();
                }
            }
        };
        return new JButton(action);
    }

    private Component getDisplayButton(Frame frm, boolean showImage) {
        Map buttonMap;
        Map map = buttonMap = showImage ? this.displayButtons_ : this.locateButtons_;
        if (!buttonMap.containsKey(frm)) {
            if (frm.getType() == FrameType.IMAGE || frm.getType() == FrameType.TABLE) {
                Component butt = this.createOptionButton(frm, showImage);
                buttonMap.put(frm, butt);
            } else {
                JPanel panel = new JPanel();
                buttonMap.put(frm, panel);
            }
        }
        return (Component)buttonMap.get(frm);
    }
}

