/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Request;
import org.eso.cpl.gui.DirectorySelector;
import org.eso.cpl.gui.GUIUtils;

public class NamingPanel
extends JPanel {
    private final JComboBox namingSelector_;
    private final DirectorySelector rootSelector_;
    private Request request_;
    private boolean locked_ = false;

    public NamingPanel() {
        this((String)null);
    }

    public NamingPanel(String productDirPath) {
        File productDir = null;
        if (productDirPath != null) {
            try {
                productDir = new File(productDirPath);
                if (!productDir.isDirectory()) {
                    productDir = null;
                }
            }
            catch (Exception ignored) {
                productDir = null;
            }
        }
        this.rootSelector_ = productDir != null ? new DirectorySelector("Product Root Directory", productDir) : new DirectorySelector("Product Root Directory");
        JTextField dirField = this.rootSelector_.getDirField();
        dirField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.textChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            void textChanged() {
                NamingPanel.this.request_.setProductRoot(NamingPanel.this.rootSelector_.getDirectory());
            }
        });
        this.namingSelector_ = new JComboBox(new Vector(NamingScheme.STANDARD_SCHEMES));
        this.namingSelector_.setSelectedIndex(0);
        this.namingSelector_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    Object selected = NamingPanel.this.namingSelector_.getSelectedItem();
                    NamingPanel.this.request_.setNamingScheme((NamingScheme)selected);
                }
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.rootSelector_);
        this.add(Box.createHorizontalStrut(20));
        this.add(new JLabel("Naming Scheme: "));
        this.add(this.namingSelector_);
        GUIUtils.wrapInBorder(this, "Product Naming");
        this.setRequest(new Request(null, null, null, null, NamingScheme.NUMERIC));
    }

    public void setRequest(Request req) {
        this.request_ = req;
        if (this.request_.getProductRoot() == null) {
            this.request_.setProductRoot(NamingPanel.getDefaultProductRoot());
        }
        this.namingSelector_.setSelectedItem(req.getNamingScheme());
        this.rootSelector_.setDirectory(req.getProductRoot());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public boolean isLocked() {
        return this.locked_;
    }

    public void setLocked(boolean locked) {
        this.locked_ = locked;
        this.namingSelector_.setEnabled(!locked);
        this.rootSelector_.setEnabled(!locked);
    }

    public static File getDefaultProductRoot() {
        return DirectorySelector.getDefaultDirectory();
    }
}

