/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eso.cpl.Request;
import org.eso.cpl.gui.Icons;
import org.eso.cpl.gui.RequestPool;

public class RequestPoolDisplay
extends JList {
    private RequestPool pool;

    public RequestPoolDisplay(RequestPool p) {
        super(p.items_);
        this.pool = p;
        String deleteLabel = "DELETE_CURRENT_REQUEST";
        this.getActionMap().put(deleteLabel, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                RequestPoolDisplay.this.removeSelectedRequest();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), deleteLabel);
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                int[] selection = RequestPoolDisplay.this.getSelectedIndices();
                RequestPoolDisplay.this.pool.setRequestSelection(selection);
            }
        });
        this.setCellRenderer(new RequestCellRenderer());
    }

    public JScrollPane wrapInScroller() {
        Box hbox = new Box(0);
        hbox.add(this);
        hbox.add(Box.createHorizontalGlue());
        Box vbox = new Box(1);
        vbox.add(Box.createVerticalGlue());
        vbox.add(hbox);
        JScrollPane scroller = new JScrollPane(vbox){

            @Override
            public Dimension getPreferredSize() {
                Dimension d2 = super.getPreferredSize();
                d2.width = 128;
                return d2;
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width, super.getMaximumSize().height);
            }
        };
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.getViewport().setBackground(this.getBackground());
        return scroller;
    }

    public void removeSelectedRequest() {
        this.removeRequest(this.getSelectedIndex());
    }

    public void removeRequest(int row) {
        ListModel mdl = this.getModel();
        if (row >= 0 && row < mdl.getSize() && mdl instanceof DefaultListModel) {
            ((DefaultListModel)mdl).remove(row);
        }
    }

    static class RequestCellRenderer
    extends JLabel
    implements ListCellRenderer {
        static final Icon okIcon = Icons.EXECOK;
        static final Icon errIcon = Icons.EXECERR;
        static final Icon emptyIcon = Icons.EXECBLANK;

        RequestCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value.toString();
            Icon image = emptyIcon;
            if (value instanceof Request) {
                Request r = (Request)value;
                if (r.getState() == 2) {
                    image = okIcon;
                } else if (r.getState() == 3) {
                    image = errIcon;
                }
            }
            this.setText(text);
            this.setIcon(image);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

