/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.jni;

import java.io.PrintStream;
import org.eso.cpl.jni.MessageListener;

public class StreamMessageListener
implements MessageListener {
    private PrintStream out_;
    private PrintStream err_;

    public StreamMessageListener(PrintStream out, PrintStream err) {
        this.out_ = out;
        this.err_ = err;
    }

    public StreamMessageListener() {
        this(System.out, System.err);
    }

    public void setOutputStream(PrintStream out) {
        this.out_ = out;
    }

    public void setErrorStream(PrintStream err) {
        this.err_ = err;
    }

    public PrintStream getOutputStream() {
        return this.out_;
    }

    public PrintStream getErrorStream() {
        return this.err_;
    }

    @Override
    public void outMessage(String msg) {
        PrintStream out = this.getOutputStream();
        if (out != null) {
            out.print(msg);
        }
    }

    @Override
    public void errMessage(String msg) {
        PrintStream err = this.getErrorStream();
        if (err != null) {
            err.print(msg);
        }
    }

    @Override
    public void logMessage(String domain, String message, int flags) {
        PrintStream out = this.getOutputStream();
        if (out != null) {
            out.print(StreamMessageListener.formatMessage(domain, message, flags));
        }
    }

    public static String formatMessage(String domain, String message, int flags) {
        return domain + ": " + flags + "\t" + message;
    }
}

