/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class RecallingComboBoxModel
extends DefaultComboBoxModel
implements ActionListener {
    private boolean sortList = false;
    private int maxCapacity = 20;
    private List selectionHistory = new ArrayList();

    public RecallingComboBoxModel() {
        this(false);
    }

    public RecallingComboBoxModel(boolean sort) {
        this.sortList = sort;
    }

    public RecallingComboBoxModel(Object[] items) {
        super(items);
    }

    public RecallingComboBoxModel(Vector v) {
        super(v);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            JComboBox cb = (JComboBox)e2.getSource();
            Object o = cb.getSelectedItem();
            this.updateModel(o);
            cb.setSelectedItem(o);
        }
    }

    @Override
    public void addElement(Object obj) {
        this.updateModel(obj);
    }

    protected void updateModel(Object newSelection) {
        boolean newItem;
        if (newSelection != null && newSelection.toString().length() > 0 && (newItem = this.recordSelection(newSelection))) {
            this.trimToCapacity();
            this.sort();
        }
    }

    protected boolean recordSelection(Object newSelection) {
        boolean newItem;
        int idx = this.selectionHistory.indexOf(newSelection);
        boolean bl = newItem = idx < 0;
        if (idx > 0) {
            this.selectionHistory.remove(idx);
            this.selectionHistory.add(0, newSelection);
        } else if (idx < 0) {
            this.selectionHistory.add(0, newSelection);
        }
        if (newItem) {
            super.addElement(newSelection);
        }
        return newItem;
    }

    protected void trimToCapacity() {
        while (this.selectionHistory.size() > this.maxCapacity) {
            Object removedItem = this.selectionHistory.remove(this.selectionHistory.size() - 1);
            if (removedItem == null) continue;
            super.removeElement(removedItem);
        }
    }

    protected void sort() {
        if (this.sortList) {
            int i;
            ArrayList l = new ArrayList();
            for (i = 0; i < this.getSize(); ++i) {
                l.add(this.getElementAt(i));
            }
            Collections.sort(l, Collator.getInstance());
            super.removeAllElements();
            for (i = 0; i < l.size(); ++i) {
                super.addElement(l.get(i));
            }
        }
    }

    public boolean isSortList() {
        return this.sortList;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int max) {
        if (max >= 0) {
            this.maxCapacity = max;
            this.trimToCapacity();
            this.sort();
        }
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        super.insertElementAt(obj, index);
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.selectionHistory.clear();
    }

    @Override
    public void removeElement(Object obj) {
        super.removeElement(obj);
        this.selectionHistory.remove(obj);
    }

    @Override
    public void removeElementAt(int index) {
        Object obj = this.getElementAt(index);
        super.removeElementAt(index);
        this.selectionHistory.remove(obj);
    }
}

