/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.cpl;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;
import org.eso.cpl.Recipe;
import org.eso.cpl.Request;
import org.eso.cpl.gui.CPLFrame;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.properties.PropertyDB;

public class RecipePanelList {
    public static final String PRODUCT_DIR_KEY = "PRODUCT_DIR";
    private Map panels = new HashMap();
    private List listeners = new ArrayList();

    public void addRecipePanel(Recipe recipe, List obComponents, LibraryLoader loader) {
        String panelName = this.getNewName(recipe.getName() + " v" + recipe.getVersion());
        String productDirPath = PropertyDB.getInstance().getProperty(PRODUCT_DIR_KEY);
        final CPLFrame cf = new CPLFrame(recipe, panelName, productDirPath);
        this.panels.put(panelName, cf);
        this.firePropertyChange("panels", panelName, null);
        cf.setLibraryLoader(loader);
        Request req = new Request(recipe);
        req.getInputFrames().addAll(RecipePanelList.getRecipeInputFrames(obComponents));
        cf.setSingleRequest(req);
        cf.setVisible(true);
        cf.toFront();
        cf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e2) {
                String pName = cf.getPanelName();
                RecipePanelList.this.panels.remove(pName);
                RecipePanelList.this.firePropertyChange("panels", pName, null);
            }

            @Override
            public void windowClosing(WindowEvent e2) {
                String pName = cf.getPanelName();
                RecipePanelList.this.panels.remove(pName);
                RecipePanelList.this.firePropertyChange("panels", pName, null);
            }
        });
    }

    private String getNewName(String base) {
        int idx = 2;
        String rc = base;
        while (this.panels.get(rc) != null) {
            rc = base + " (" + idx + ")";
            ++idx;
        }
        return rc;
    }

    public static FrameList getRecipeInputFrames(List obComponents) {
        FrameList inFrames = new FrameList();
        for (int i = 0; i < obComponents.size(); ++i) {
            OBComponent obc = (OBComponent)obComponents.get(i);
            if (!(obc instanceof KeywordContainerOBComponent)) continue;
            KeywordContainerOBComponent ff = (KeywordContainerOBComponent)obc;
            Frame frm = new Frame(new File(ff.getId()));
            inFrames.add(frm);
            frm.setGroup(ff.isCalibFrame() ? FrameGroup.CALIB : FrameGroup.RAW);
            frm.setLevel(FrameLevel.INTERMEDIATE);
            frm.setType(FrameType.IMAGE);
            frm.setTag(ff.getClassification());
        }
        return inFrames;
    }

    public void addInputFramesToRecipePanel(String panelName, List obComponents, boolean queue) {
        CPLFrame panel = this.getRecipePanel(panelName);
        if (panel != null) {
            if (queue) {
                panel.addInputFramesToQueue(RecipePanelList.getRecipeInputFrames(obComponents));
            } else {
                panel.addInputFramesToShownRequest(RecipePanelList.getRecipeInputFrames(obComponents));
            }
            panel.toFront();
        }
    }

    private void firePropertyChange(String property, Object oldVal, Object newVal) {
        PropertyChangeEvent e2 = new PropertyChangeEvent(this, property, oldVal, newVal);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((PropertyChangeListener)i.next()).propertyChange(e2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.removePropertyChangeListener(l);
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    public CPLFrame getRecipePanel(String name) {
        return (CPLFrame)this.panels.get(name);
    }

    public Iterator getRecipePanelNames() {
        return this.panels.keySet().iterator();
    }
}

