/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.filesystem;

import java.io.File;
import java.io.IOException;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.BaseName;

public abstract class DFSFile {
    private int fileStatus = 0;
    private long lastModified = 0L;
    private static final int SECONDS_AND_MILLI = 6;
    public static final int UNKNOWN_STATE = 0;
    public static final int FILE_NOT_FOUND = 1;
    public static final int FILE_INVALID = 2;
    public static final int FILE_VALID = 3;
    public static final int FILE_FILTERED = 4;

    public static void main(String[] args) {
        PropertyDB.getInstance().setDebugLevel(4);
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
            DFSFile.extractBaseName(args[i]);
        }
    }

    public String getStringStatus() {
        return DFSFile.getStringStatus(this.getStatus());
    }

    public static String getStringStatus(int status) {
        String rc = "unknown state";
        if (status == 1) {
            rc = new String("not found");
        } else if (status == 2) {
            rc = new String("invalid");
        } else if (status == 4) {
            rc = new String("filtered");
        } else if (status == 3) {
            rc = new String("valid");
        }
        return rc;
    }

    public void setStatus(int s) {
        this.fileStatus = s;
    }

    public int getStatus() {
        return this.fileStatus;
    }

    public long getLastModified() {
        long rc = 0L;
        File theFile = this.getPath();
        try {
            rc = theFile.lastModified();
        }
        catch (SecurityException e2) {
            System.out.println("error getting modification time: " + e2.toString());
            rc = 0L;
        }
        return rc;
    }

    public boolean dataRefreshRequired() {
        boolean rc = true;
        long lastMod = this.getLastModified();
        rc = lastMod == 0L || this.lastModified != lastMod;
        if (PropertyDB.getInstance().isDebug(1)) {
            System.out.println(this.getFileName() + " last mod time: " + lastMod + " refresh required: " + rc);
        }
        return rc;
    }

    public void dataRefreshed() {
        this.lastModified = this.getLastModified();
    }

    public abstract int readData();

    public String getBaseName() {
        return DFSFile.extractBaseName(this.getPathString());
    }

    public abstract File getPath();

    public String getPathString() {
        return this.getPath().getPath();
    }

    public String getFileName() {
        return this.getPath().getName();
    }

    public static String getFileName(String name) {
        File f = new File(name);
        return f.getName();
    }

    public static String removeSuffix(String fullPath) {
        String rc = fullPath;
        int endBaseName = fullPath.lastIndexOf(95);
        if (endBaseName != -1 && fullPath.charAt(endBaseName + 1) != 't') {
            try {
                rc = fullPath.substring(0, endBaseName);
            }
            catch (StringIndexOutOfBoundsException e2) {
                System.out.println(e2.toString());
                rc = fullPath;
            }
        }
        if (rc == fullPath) {
            endBaseName = fullPath.lastIndexOf(46);
            try {
                rc = fullPath.substring(0, endBaseName);
            }
            catch (StringIndexOutOfBoundsException e3) {
                System.out.println(e3.toString());
                rc = fullPath;
            }
        }
        return rc;
    }

    public static String getCanonicalPath(String fullPath) {
        String rc = null;
        try {
            File file = new File(fullPath);
            rc = file.getCanonicalPath();
        }
        catch (IOException e2) {
            rc = null;
        }
        return rc;
    }

    public static String extractBaseName(String fullPath) {
        return BaseName.extractBaseName(fullPath);
    }
}

