/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.dfspipeline;

import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import org.eso.gasgano.dfspipeline.DFSPipelineStatusListener;
import org.eso.gasgano.tools.Exec;

public class InfrastructureWatch
extends Thread {
    private String commandOne = null;
    private String doProcess;
    private String rbsProcess;
    int updateSec = 10;
    private Vector outString = null;
    private Vector errString = null;
    private Vector pipelineListeners = new Vector();

    public InfrastructureWatch() {
        this.commandOne = new String("");
        if (System.getProperty("os.name").equals("HP-UX")) {
            this.commandOne = this.commandOne.concat("/usr/bin/ps -fu ");
        }
        if (System.getProperty("os.name").equals("Solaris")) {
            this.commandOne = this.commandOne.concat("/usr/bin/ps -fu ");
        }
        this.commandOne = this.commandOne.concat(System.getProperty("user.name").toString());
        if (System.getProperty("os.name").equals("HP-UX")) {
            this.commandOne = this.commandOne.concat(" -o comm");
        }
        this.doProcess = new String("pilDataOrganizer");
        this.rbsProcess = new String("pilScheduler");
        this.outString = new Vector();
        this.errString = new Vector();
    }

    public void addDFSPipelineStatusListener(DFSPipelineStatusListener l) {
        this.pipelineListeners.add(l);
    }

    public void removeDFSPipelineStatusListener(DFSPipelineStatusListener l) {
        this.pipelineListeners.remove(l);
    }

    void fireCheck() {
        boolean doStatus = false;
        boolean rbsStatus = false;
        if (Exec.shellCommand(this.commandOne, this.errString, this.outString) != 0) {
            System.err.println(">> external shell command failed: notify parent class");
            System.err.println(">> command was: " + this.commandOne);
        }
        Enumeration e2 = this.outString.elements();
        while (e2.hasMoreElements()) {
            String lineTmp = (String)e2.nextElement();
            if (lineTmp.indexOf(this.doProcess) != -1) {
                doStatus = true;
            }
            if (lineTmp.indexOf(this.rbsProcess) != -1) {
                rbsStatus = true;
            }
            for (int i = 0; i < this.pipelineListeners.size(); ++i) {
                ((DFSPipelineStatusListener)this.pipelineListeners.get(i)).notifyDORunning(doStatus);
                ((DFSPipelineStatusListener)this.pipelineListeners.get(i)).notifyRBSRunning(rbsStatus);
            }
        }
        e2 = this.errString.elements();
        while (e2.hasMoreElements()) {
            System.out.println(e2.nextElement());
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.updateSec * 1000);
                    this.fireCheck();
                }
            }
            catch (InterruptedException e2) {
                System.err.println("InterruptedException");
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        Object Environment2 = null;
        Object e2 = null;
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        JRadioButton RBS_Button = new JRadioButton("RBS");
        RBS_Button.setBorderPainted(false);
        frame.getContentPane().setLayout(new GridLayout(2, 1));
        frame.getContentPane().add(RBS_Button);
        frame.setLocation(200, 200);
        frame.pack();
        frame.setVisible(true);
    }
}

