/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eso.gasgano.gui.FontChooser;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.gui.KeywordListAdaptor;
import org.eso.gasgano.gui.ListAdaptor;
import org.eso.gasgano.gui.PropertyCellEditor;
import org.eso.gasgano.gui.PropertyEditorSubPanel;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.InstGroupTableModel;
import org.eso.gasgano.properties.PropertyTableModel;
import org.eso.gasgano.viewers.ExternalViewerFactory;

public class DisplayPanel
extends PropertyEditorSubPanel
implements ActionListener {
    private GasProp gpi;
    private JTextField tfitsToViewer;
    private JTextField fitsToViewer;
    private JTextField cubeToViewer;
    private JComboBox tfitsViewerType;
    private JComboBox fitsViewerType;
    private JComboBox cubeViewerType;
    private JTextField printJtf;
    private JTable fsDispKeys;
    private JTable instrTable;
    private InstGroupTableModel instrTableModel;
    private JButton instTableInsertRow;
    private JButton instTableDeleteRow;
    private KeywordListAdaptor fsDispKeysModel;
    private String fsHeaderLabel = new String("Filesystem - Displayed Keywords");
    private JButton insertRow1;
    private JButton deleteRow1;
    private JButton fontChooser;
    private JRadioButton shortName;
    private JRadioButton radecConversion;
    private JRadioButton showExtensions;
    private JRadioButton mjdSorting;
    private JComboBox printOrient;
    private String[] orients = new String[]{"landscape", "portrait"};
    private JLabel fontInUse;
    private Font selectedFont;
    private String newFontProperty = null;

    public DisplayPanel(GasProp gp) {
        JPanel jpRadio = new JPanel(new GridLayout(4, 1));
        JPanel jpElse = new JPanel(new BorderLayout());
        JPanel jpLeft = new JPanel(new BorderLayout());
        Vector viewerTypes = ExternalViewerFactory.getInstance().getViewerTypes();
        this.printOrient = new JComboBox<String>(this.orients);
        this.printJtf = new JTextField(12);
        this.printJtf.addActionListener(this);
        this.tfitsToViewer = new JTextField(12);
        this.tfitsToViewer.setToolTipText("Path to viewer command");
        this.tfitsToViewer.addActionListener(this);
        this.tfitsViewerType = new JComboBox(viewerTypes);
        this.fitsToViewer = new JTextField(12);
        this.fitsToViewer.setToolTipText("Path to viewer command");
        this.fitsToViewer.addActionListener(this);
        this.fitsViewerType = new JComboBox(viewerTypes);
        this.cubeToViewer = new JTextField(12);
        this.cubeToViewer.setToolTipText("Path to viewer command");
        this.cubeToViewer.addActionListener(this);
        this.cubeViewerType = new JComboBox(viewerTypes);
        this.insertRow1 = new JButton("Insert Row");
        this.insertRow1.setToolTipText("Left-click for insert below, right-click for insert above.");
        this.insertRow1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if ((e2.getModifiers() & 4) != 0) {
                    DisplayPanel.this.insertBlankRow(DisplayPanel.this.fsDispKeys, false);
                }
                if ((e2.getModifiers() & 0x10) != 0) {
                    DisplayPanel.this.insertBlankRow(DisplayPanel.this.fsDispKeys, true);
                }
            }
        });
        this.deleteRow1 = new JButton("Delete Row");
        this.deleteRow1.setToolTipText("Delete selected row.");
        this.deleteRow1.addActionListener(this);
        this.fontChooser = new JButton("Choose new font");
        this.fontChooser.addActionListener(this);
        this.shortName = new JRadioButton("truncate filenames", false);
        this.radecConversion = new JRadioButton("convert RA/DEC", false);
        this.mjdSorting = new JRadioButton("sort by MJD", false);
        this.showExtensions = new JRadioButton("show fits extensions", false);
        this.showExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DisplayPanel.this.showExtensions.isSelected()) {
                    DisplayPanel.this.showWarning("Display of FITS extension headers is only\npossible when viewing non-compressed FITS files.\nFITS file extension headers for compressed files\nwill not be displayed.");
                }
            }
        });
        this.fontInUse = new JLabel("Font Test");
        this.fontInUse.setFont(this.selectedFont);
        this.fsDispKeys = new JTable();
        this.fsDispKeys.setRowSelectionAllowed(true);
        this.fsDispKeys.getSelectionModel().setSelectionMode(0);
        this.fsDispKeys.setPreferredScrollableViewportSize(new Dimension(240, 140));
        JPanel instGroupingPanel = this.setupInstrumentGroupingPanel(gp);
        this.fsDispKeysModel = new KeywordListAdaptor((List)gp.fsDisplayColumns, this.fsHeaderLabel, true);
        this.fsDispKeys.setModel(this.fsDispKeysModel);
        this.fsDispKeys.setDefaultEditor(this.fsDispKeys.getColumnClass(0), new PropertyCellEditor());
        this.loadProperties(gp);
        jpRadio = new JPanel(new GridLayout(4, 1));
        jpElse = new JPanel(new BorderLayout());
        jpLeft = new JPanel(new BorderLayout());
        jpLeft.setBorder(new TitledBorder("Display Columns and Formats"));
        JPanel jpr = new JPanel(new GridLayout(15, 1));
        JPanel jpl = new JPanel(new GridLayout(15, 1));
        JPanel jpTable1 = new JPanel(new BorderLayout());
        JPanel jpSouth = new JPanel(new BorderLayout());
        JScrollPane scrollPane1 = new JScrollPane(this.fsDispKeys);
        scrollPane1.setVerticalScrollBarPolicy(22);
        JPanel jpOptions = new JPanel(new BorderLayout());
        jpOptions.setBorder(new EmptyBorder(3, 3, 3, 3));
        jpTable1.setBorder(new EmptyBorder(5, 5, 5, 5));
        jpElse.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jplower = new JPanel();
        jplower.add(this.insertRow1);
        jplower.add(this.deleteRow1);
        jpTable1.add((Component)scrollPane1, "Center");
        jpTable1.add((Component)jplower, "South");
        jpLeft.add((Component)jpTable1, "North");
        jpRadio.add(this.shortName);
        jpRadio.add(this.radecConversion);
        jpRadio.add(this.mjdSorting);
        jpRadio.add(this.showExtensions);
        jpRadio.setBorder(new EmptyBorder(5, 5, 5, 5));
        jpl.add(new JLabel("Printer Settings"));
        jpl.add(new JLabel("Printer Name:"));
        jpl.add(new JLabel("Printer orientation"));
        jpl.add(new JLabel("Printer Font:"));
        jpl.add(new JLabel(""));
        jpl.add(new JLabel(""));
        jpl.add(new JLabel("External Viewers"));
        jpl.add(new JLabel("Tfits Viewer:"));
        jpl.add(new JLabel("Tfits Viewer Type:"));
        jpl.add(new JLabel(""));
        jpl.add(new JLabel("Fits Viewer:"));
        jpl.add(new JLabel("Fits Viewer Type:"));
        jpl.add(new JLabel(""));
        jpl.add(new JLabel("Cube Viewer:"));
        jpl.add(new JLabel("Cube Viewer Type:"));
        jpr.add(new JLabel(""));
        jpr.add(this.printJtf);
        jpr.add(this.printOrient);
        jpr.add(this.fontChooser);
        jpr.add(this.fontInUse);
        jpr.add(new JLabel(""));
        jpr.add(new JLabel(""));
        jpr.add(DisplayPanel.setupFileChooserPanel(this.tfitsToViewer, 0));
        jpr.add(this.tfitsViewerType);
        jpr.add(new JLabel(""));
        jpr.add(DisplayPanel.setupFileChooserPanel(this.fitsToViewer, 0));
        jpr.add(this.fitsViewerType);
        jpr.add(new JLabel(""));
        jpr.add(DisplayPanel.setupFileChooserPanel(this.cubeToViewer, 0));
        jpr.add(this.cubeViewerType);
        jpOptions.add((Component)jpl, "West");
        jpOptions.add((Component)jpr, "East");
        jpElse.add((Component)jpOptions, "North");
        jpElse.add((Component)jpSouth, "Center");
        TableColumn mColumn = this.fsDispKeys.getColumn(this.fsHeaderLabel);
        mColumn.setResizable(false);
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.setLayout(new BorderLayout());
        jpLeft.add((Component)jpRadio, "South");
        this.add((Component)jpElse, "East");
        this.add((Component)jpLeft, "West");
        this.add((Component)instGroupingPanel, "South");
    }

    private JPanel setupInstrumentGroupingPanel(GasProp gp) {
        JPanel instTableButtonPanel = new JPanel();
        this.instrTable = new JTable();
        this.instrTableModel = new InstGroupTableModel(gp);
        this.instrTableModel.setDebug(this.isDebug());
        this.instrTable.setModel(this.instrTableModel);
        this.instrTable.setDefaultEditor(this.instrTable.getColumnClass(1), new PropertyCellEditor());
        this.instrTable.setCellSelectionEnabled(true);
        this.instrTable.setPreferredScrollableViewportSize(new Dimension(240, 220));
        TableColumn mColumn = this.instrTable.getColumn("instrument");
        mColumn.setMinWidth(30);
        mColumn.setResizable(false);
        this.instTableInsertRow = new JButton("Insert Row");
        this.instTableInsertRow.addActionListener(this);
        this.instTableDeleteRow = new JButton("Delete Row");
        this.instTableDeleteRow.addActionListener(this);
        instTableButtonPanel.add(this.instTableInsertRow);
        instTableButtonPanel.add(this.instTableDeleteRow);
        String label = GasProp.isEnvironmentSafe() ? "Instrument Specific Grouping (filesystem view only)" : "Instrument Specific Grouping";
        JPanel instGroupingPanel = new JPanel(new BorderLayout());
        instGroupingPanel.setBorder(new TitledBorder(label));
        JScrollPane scroller = new JScrollPane(this.instrTable);
        scroller.setPreferredSize(new Dimension(100, 100));
        instGroupingPanel.add((Component)scroller, "Center");
        instGroupingPanel.add((Component)instTableButtonPanel, "South");
        return instGroupingPanel;
    }

    @Override
    public void loadProperties(GasProp gp) {
        this.gpi = gp;
        this.fsDispKeysModel.setData(gp.fsDisplayColumns);
        this.instrTable.getDefaultEditor(this.instrTable.getColumnClass(0)).cancelCellEditing();
        this.instrTableModel.loadProperties(this.gpi);
        String fontFull = this.gpi.getProperty("PRINT_FONT");
        String fontName = fontFull.substring(0, fontFull.indexOf(":", 0));
        String fontSize = fontFull.substring(fontFull.indexOf(":", 0) + 1, fontFull.length());
        this.selectedFont = new Font(fontName, 0, Integer.parseInt(fontSize));
        this.printJtf.setText(this.gpi.getProperty("PRINTER_NAME"));
        this.printJtf.addActionListener(this);
        if (this.gpi.getProperty("PRINT_ORIENTATION").equals("L")) {
            this.printOrient.setSelectedIndex(0);
        }
        if (this.gpi.getProperty("PRINT_ORIENTATION").equals("P")) {
            this.printOrient.setSelectedIndex(1);
        }
        this.tfitsToViewer.setText(this.gpi.getProperty("TFITS_TO_VIEWER"));
        this.tfitsViewerType.setSelectedItem(this.gpi.getProperty("TFITS_VIEWER_TYPE"));
        this.fitsToViewer.setText(this.gpi.getProperty("FITS_TO_VIEWER"));
        this.fitsViewerType.setSelectedItem(this.gpi.getProperty("FITS_VIEWER_TYPE"));
        this.cubeToViewer.setText(this.gpi.getProperty("CUBE_TO_VIEWER"));
        this.cubeViewerType.setSelectedItem(this.gpi.getProperty("CUBE_VIEWER_TYPE"));
        if (this.gpi.getProperty("SHORT_FILENAME") != null && this.gpi.getProperty("SHORT_FILENAME").equals("true")) {
            this.shortName.setSelected(true);
        }
        if (this.gpi.getProperty("RADEC_CONVERSION") != null && this.gpi.getProperty("RADEC_CONVERSION").equals("true")) {
            this.radecConversion.setSelected(true);
        }
        if (this.gpi.getProperty("MJD_SORTING") != null && this.gpi.getProperty("MJD_SORTING").equals("true")) {
            this.mjdSorting.setSelected(true);
        }
        if (this.gpi.getProperty("SHOW_EXTENSIONS") != null && this.gpi.getProperty("SHOW_EXTENSIONS").equals("true")) {
            this.showExtensions.setSelected(true);
        }
    }

    @Override
    public String saveProperties() {
        String rc = null;
        GUIUtils.stopEditing(this.fsDispKeys);
        for (int i = 0; i < this.gpi.fsDisplayColumns.size(); ++i) {
            if (!this.gpi.fsDisplayColumns.elementAt(i).toString().equals("") && !this.gpi.fsDisplayColumns.elementAt(i).toString().equals("*INVALID*") && this.gpi.fsDisplayColumns.elementAt(i) != null) continue;
            this.gpi.fsDisplayColumns.removeElementAt(i);
        }
        if (this.shortName.isSelected()) {
            this.gpi.put("SHORT_FILENAME", "true");
        } else {
            this.gpi.put("SHORT_FILENAME", "false");
        }
        if (this.radecConversion.isSelected()) {
            this.gpi.put("RADEC_CONVERSION", "true");
        } else {
            this.gpi.put("RADEC_CONVERSION", "false");
        }
        if (this.mjdSorting.isSelected()) {
            this.gpi.put("MJD_SORTING", "true");
        } else {
            this.gpi.put("MJD_SORTING", "false");
        }
        if (this.showExtensions.isSelected()) {
            this.gpi.put("SHOW_EXTENSIONS", "true");
        } else {
            this.gpi.put("SHOW_EXTENSIONS", "false");
        }
        this.gpi.put("TFITS_TO_VIEWER", this.tfitsToViewer.getText());
        String viewer = (String)this.tfitsViewerType.getSelectedItem();
        if (viewer == null) {
            viewer = "";
        }
        this.gpi.put("TFITS_VIEWER_TYPE", viewer);
        this.gpi.put("FITS_TO_VIEWER", this.fitsToViewer.getText());
        viewer = (String)this.fitsViewerType.getSelectedItem();
        if (viewer == null) {
            viewer = "";
        }
        this.gpi.put("FITS_VIEWER_TYPE", viewer);
        this.gpi.put("CUBE_TO_VIEWER", this.cubeToViewer.getText());
        viewer = (String)this.cubeViewerType.getSelectedItem();
        if (viewer == null) {
            viewer = "";
        }
        this.gpi.put("CUBE_VIEWER_TYPE", viewer);
        this.gpi.put("PRINTER_NAME", this.printJtf.getText());
        this.gpi.put("PRINT_ORIENTATION", this.printOrient.getSelectedIndex() == 0 ? "L" : "P");
        this.selectedFont = null;
        if (this.newFontProperty != null) {
            this.gpi.put("PRINT_FONT", this.newFontProperty);
            this.newFontProperty = null;
        }
        return rc;
    }

    @Override
    public int restartRequired() {
        int i;
        this.instrTable.getDefaultEditor(this.instrTable.getColumnClass(0)).stopCellEditing();
        for (i = 0; i < this.gpi.instruments.size(); ++i) {
            if (!((String)this.gpi.instruments.elementAt(i)).equals("")) continue;
            this.gpi.instruments.removeElementAt(i);
            this.gpi.instrumentGrouping.removeElementAt(i);
            ((PropertyTableModel)this.instrTable.getModel()).fireTableDataChanged();
        }
        if (this.gpi.instrumentGrouping.size() != GasProp.getProperties().instrumentGrouping.size()) {
            return 1;
        }
        for (i = 0; i < this.gpi.instrumentGrouping.size(); ++i) {
            if (this.gpi.instrumentGrouping.elementAt(i).equals(GasProp.getProperties().instrumentGrouping.elementAt(i))) continue;
            return 1;
        }
        if (this.mjdSorting.isSelected() && GasProp.getProperties().getProperty("MJD_SORTING").equals("false") || !this.mjdSorting.isSelected() && GasProp.getProperties().getProperty("MJD_SORTING").equals("true")) {
            return 1;
        }
        return 0;
    }

    void fireFontChooser() {
        FontChooser fc = new FontChooser(this.selectedFont);
        if (JOptionPane.showConfirmDialog(this, fc, "Edit fonts", 2, -1) == 0) {
            if (this.isDebug()) {
                System.out.println("selected Font is:" + fc.getNewFont().getName() + ":" + fc.getNewFont().getSize());
            }
            this.newFontProperty = fc.getNewFont().getName() + ":" + fc.getNewFont().getSize();
            this.fontInUse.setFont(fc.getNewFont());
            this.selectedFont = fc.getNewFont();
        }
    }

    private void insertBlankRow(final JTable table, boolean after) {
        GUIUtils.stopEditing(table);
        int selRow = table.getSelectedRow() < 0 ? (after ? table.getRowCount() - 1 : 0) : table.getSelectedRow();
        if (this.isDebug()) {
            System.out.println("Insert selected row: " + selRow + " after: " + after);
        }
        if (after && table.getRowCount() != 0) {
            TableModel mdl = table.getModel();
            if (mdl instanceof ListAdaptor) {
                ((ListAdaptor)mdl).insertRow(selRow + 1, "");
            } else if (mdl instanceof PropertyTableModel) {
                ((PropertyTableModel)mdl).insertRow(selRow + 1);
            }
            final int selRowFinal = selRow;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.clearSelection();
                    table.setRowSelectionInterval(selRowFinal + 1, selRowFinal + 1);
                }
            });
        } else {
            TableModel mdl = table.getModel();
            if (mdl.getRowCount() == 0) {
                selRow = 0;
            }
            if (mdl instanceof ListAdaptor) {
                ((ListAdaptor)mdl).insertRow(selRow, "");
            } else if (mdl instanceof PropertyTableModel) {
                ((PropertyTableModel)mdl).insertRow(selRow);
            }
            final int selRowFinal = selRow;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.clearSelection();
                    table.setRowSelectionInterval(selRowFinal, selRowFinal);
                }
            });
        }
    }

    private void deleteSelectedRow(final JTable table) {
        TableModel mdl;
        GUIUtils.stopEditing(table);
        final int selRow = table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        if (this.isDebug()) {
            System.out.println("Delete selected row: " + selRow);
        }
        if ((mdl = table.getModel()) instanceof ListAdaptor) {
            ((ListAdaptor)mdl).removeRow(selRow);
        } else if (mdl instanceof PropertyTableModel) {
            ((PropertyTableModel)mdl).removeRow(selRow);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                table.clearSelection();
                int row = table.getRowCount() <= selRow ? table.getRowCount() - 1 : selRow;
                if (row >= 0) {
                    table.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.deleteRow1) {
            this.deleteSelectedRow(this.fsDispKeys);
        } else if (e2.getSource() == this.printJtf) {
            this.gpi.put("PRINTER_NAME", this.printJtf.getText());
        } else if (e2.getSource() == this.fontChooser) {
            this.fireFontChooser();
        } else if (e2.getSource() == this.instTableDeleteRow) {
            this.deleteSelectedRow(this.instrTable);
        } else if (e2.getSource() == this.instTableInsertRow) {
            this.insertBlankRow(this.instrTable, true);
        }
    }

    private void showWarning(String warning) {
        JOptionPane.showMessageDialog(this, warning, "Warning", 0);
    }
}

