/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.gui.KeywordListEditor;
import org.eso.gasgano.gui.KeywordTable;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.DirUtils;

public class KeywordListLoader
extends JPanel
implements ActionListener {
    private KeywordListEditor editorPanel = null;
    private KeywordTable kwTable = null;
    private static final String openItem = "Load Keyword List";
    private JButton openButton = null;
    private JFileChooser fileChooser = null;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Keyword Loader");
        KeywordListLoader loader = new KeywordListLoader();
        if (JOptionPane.showConfirmDialog(frame, loader, "Load keyword list", 2, -1) == 0) {
            int i;
            Vector vec = loader.getKeywordTable().getKeywordList();
            for (i = 0; i < vec.size(); ++i) {
                System.out.println(vec.elementAt(i).toString());
            }
            vec = loader.getKeywordTable().getKeywordLabelList();
            for (i = 0; i < vec.size(); ++i) {
                System.out.println(vec.elementAt(i).toString());
            }
        }
        System.exit(0);
    }

    public KeywordListLoader() {
        super(new BorderLayout());
        this.kwTable = new KeywordTable();
        this.init();
    }

    public KeywordListLoader(String kwFile) {
        super(new BorderLayout());
        this.kwTable = new KeywordTable(kwFile);
        this.init();
    }

    private void init() {
        JPanel buttonPanel = new JPanel();
        this.editorPanel = new KeywordListEditor(this.kwTable);
        this.editorPanel.setReadOnly(true);
        this.add((Component)this.editorPanel, "Center");
        this.openButton = new JButton(openItem);
        this.openButton.addActionListener(this);
        buttonPanel.add(this.openButton);
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getActionCommand() == openItem) {
            this.openFile();
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            DFSDataModel dm = DFSDataModel.getDataModel();
            String kwDir = DirUtils.convertAbsoluteDir(PropertyDB.getInstance().getProperty("KEYWORDLIST_DIR"));
            this.fileChooser = new SwingFileChooser(kwDir);
        } else {
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    public KeywordTable getKeywordTable() {
        return this.kwTable;
    }

    private void openFile() {
        String selectedFile;
        JFileChooser openChooser = this.getFileChooser();
        openChooser.setFileSelectionMode(0);
        openChooser.setDialogType(0);
        openChooser.setDialogTitle("Select keyword list file");
        openChooser.setApproveButtonText("Load");
        openChooser.setMultiSelectionEnabled(false);
        if (openChooser.showOpenDialog(this) == 0 && openChooser.getSelectedFile() != null && !this.kwTable.readFile(selectedFile = openChooser.getSelectedFile().getPath())) {
            this.userMessage("Errors reading: " + selectedFile);
        }
    }

    public void userMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }
}

