/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Component;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class PropertyCellEditor
extends JTextField
implements TableCellEditor {
    protected Vector listeners = new Vector();
    protected String originalValue;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null) {
            this.setText((String)value);
        }
        this.originalValue = this.getText();
        return this;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean isCellEditable(EventObject eo) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return new String(this.getText());
    }

    @Override
    public boolean shouldSelectCell(EventObject eo) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cel) {
        this.listeners.addElement(cel);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cel) {
        this.listeners.removeElement(cel);
    }

    protected void fireEditingCanceled() {
        this.setText(this.originalValue);
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingCanceled(ce);
        }
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingStopped(ce);
        }
    }
}

