/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.keyword;

import java.io.Serializable;
import org.eso.dfs.util.KeywordToken;

public class Keyword
implements Serializable {
    static final long serialVersionUID = 1883435576112404647L;
    private String name = null;
    private String value = null;
    public static final String hierarchKeywordPrefix = "HIERARCH ESO";
    public static final String INSTRUMENT = "INSTRUME";
    public static final String TELESCOP = "TELESCOP";
    public static final String ARCFILE = "ARCFILE";
    public static final String PROG_ID = "OBS.PROG.ID";
    public static final String OBS_ID = "OBS.ID";
    public static final String OBS_NAME = "OBS.NAME";
    public static final String DATE = "DATE";
    public static final String PI = "PI-COI";
    public static final String PIPELINE_IDENT = "PRO.CATG";
    public static final String DRPCATG = "DPR.CATG";
    public static final String MD5SIG = "DATAMD5";
    public static final String ORIGFILE = "ORIGFILE";
    public static final String EXTENSION = "EXTEND";
    public static final String NAXIS = "NAXIS";
    public static final String AXIS = "NAXIS";
    public static final String BITPIX = "BITPIX";
    public static final String EXTENDSTART = "XTENSION";
    public static final String SIMPLESTART = "SIMPLE";
    public static final int METAKEYWORD_SEPARATOR = 95;
    public static final int DASH_SEPARATOR = 45;
    public static final String CLASSIFICATION_METAKEYWORD = "CLASSIFICATION";
    public static final String FILE_PATH_METAKEYWORD = "FILE_PATH";
    public static final String PIPE_PRODUCT_METAKEYWORD = "PIPE_PRODUCT";
    public static final String EXTENSION_METAKEYWORD = "EXTENSION";
    public static final String EXTENSION_NAME = "EXTNAME";
    public static final String EXTENSION_VERSION = "EXTVER";
    public static final String RBPRODUCT_NAME = "PRO.REC1.RAW1.NAME";

    public Keyword(String n, String v) {
        this.setName(n);
        this.setValue(v);
    }

    public Keyword(KeywordToken kwt) {
        this.setName(kwt.getName());
        this.setValue(kwt.getValue());
    }

    public static void main(String[] args) {
        System.out.println("valid keyword name: FRED: " + Keyword.validName("FRED"));
        System.out.println("valid keyword name: F RED: " + Keyword.validName("F RED"));
        System.out.println("valid keyword name: F-RED: " + Keyword.validName("F-RED"));
        System.out.println("valid keyword name: F_RED: " + Keyword.validName("F_RED"));
        System.out.println("valid keyword name: 99X: " + Keyword.validName("99X"));
        System.out.println("valid keyword name: TPL.ID: " + Keyword.validName("TPL.ID"));
        System.out.println("valid keyword name: tpl.ID: " + Keyword.validName("tpl.ID"));
        System.out.println("valid keyword name: HIERARCH ESO TPL ID: " + Keyword.validName("HIERARCH ESO TPL ID"));
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
            System.out.println("    Full Name: " + Keyword.convertDotNameToFull(args[i]));
            System.out.println("    Dot Name: " + Keyword.convertFullNameToDot(args[i]));
        }
    }

    public static String convertDotNameToFull(String dotName) {
        String rc = dotName;
        if (rc.indexOf(46) != -1) {
            rc = "HIERARCH ESO " + dotName.replace('.', ' ');
        }
        return rc;
    }

    public static String convertFullNameToDot(String fullName) {
        String rc = null;
        if (fullName.startsWith(hierarchKeywordPrefix)) {
            try {
                rc = fullName.substring(hierarchKeywordPrefix.length() + 1);
                rc = rc.replace(' ', '.');
            }
            catch (StringIndexOutOfBoundsException e2) {
                rc = fullName;
            }
        } else {
            rc = fullName;
        }
        return rc;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return Keyword.convertDotNameToFull(this.name);
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String n) {
        this.name = Keyword.convertFullNameToDot(n);
    }

    public void setValue(String v) {
        if (v != null) {
            this.value = v.trim();
            int startIndex = this.value.indexOf(39);
            int endIndex = this.value.lastIndexOf(39);
            try {
                this.value = endIndex < 0 || endIndex == startIndex ? this.value.substring(startIndex + 1) : this.value.substring(startIndex + 1, endIndex);
                this.value = this.value.trim();
            }
            catch (StringIndexOutOfBoundsException e2) {
                System.out.println(this.getName() + " " + v + " : " + e2.toString());
            }
        } else {
            this.value = v;
        }
    }

    public Float getNumericValue() throws NumberFormatException {
        return Float.valueOf(this.getValue());
    }

    public boolean equals(Object anObject) {
        boolean rc = false;
        if (anObject instanceof String) {
            rc = this.name.equals(Keyword.convertFullNameToDot((String)anObject));
        }
        return rc;
    }

    public String toString() {
        return this.name.toString() + " = " + this.value.toString();
    }

    public static boolean validName(String kwName) {
        boolean rc = true;
        int i = 0;
        int len = kwName.length();
        char seperator = '.';
        if (kwName.startsWith(hierarchKeywordPrefix)) {
            seperator = ' ';
        }
        while (rc && i < len) {
            try {
                char c2 = kwName.charAt(i++);
                if (c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == seperator || c2 == '-') continue;
                rc = false;
            }
            catch (StringIndexOutOfBoundsException e2) {
                i = len;
            }
        }
        return rc;
    }
}

