/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.keyword;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.eso.dfs.io.UpgradingObjectInputStream;
import org.eso.gasgano.keyword.ClassificationRule;
import org.eso.gasgano.properties.PropertyDB;

public class RuleTable
extends AbstractTableModel
implements Serializable {
    private Vector rules = new Vector();
    private Hashtable instRuleSet = new Hashtable();
    private static String[] columnNames = new String[]{"Instrument", "Classification", "Rule"};
    private String ruleTablePath = null;

    public RuleTable(String filePath) {
        this.ruleTablePath = filePath;
    }

    @Override
    public String getColumnName(int c2) {
        return columnNames[c2];
    }

    public String getTablePath() {
        return this.ruleTablePath;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.rules.size();
    }

    @Override
    public Object getValueAt(int r, int c2) {
        ClassificationRule rule = (ClassificationRule)this.rules.elementAt(r);
        String rc = null;
        rc = c2 == 0 ? rule.getInstrument() : (c2 == 1 ? rule.getClassification() : rule.getRule().toString());
        return rc;
    }

    public int getColumnWidth(int column) {
        if (column == 2) {
            return 30;
        }
        return 10;
    }

    @Override
    public boolean isCellEditable(int r, int c2) {
        return false;
    }

    public Enumeration elements() {
        return this.rules.elements();
    }

    public Enumeration elements(String instName) {
        Enumeration rc = null;
        Vector vec = (Vector)this.instRuleSet.get(instName);
        rc = vec != null ? vec.elements() : new Vector().elements();
        return rc;
    }

    public final synchronized boolean removeElement(Object obj) {
        ClassificationRule cr;
        Vector instrumentRules;
        boolean rc = this.rules.removeElement(obj);
        if (rc && (instrumentRules = (Vector)this.instRuleSet.get((cr = (ClassificationRule)obj).getInstrument())) != null) {
            instrumentRules.removeElement(obj);
        }
        this.fireTableDataChanged();
        return rc;
    }

    public ClassificationRule elementAt(int index) {
        ClassificationRule rc = null;
        try {
            rc = (ClassificationRule)this.rules.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println(e2.toString());
        }
        return rc;
    }

    public final synchronized void removeElementAt(int index) {
        try {
            ClassificationRule cr = (ClassificationRule)this.rules.elementAt(index);
            this.rules.removeElementAt(index);
            Vector instrumentRules = (Vector)this.instRuleSet.get(cr.getInstrument());
            if (instrumentRules != null) {
                instrumentRules.removeElement(cr);
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println(e2.toString());
        }
        this.fireTableDataChanged();
    }

    public final synchronized void addElement(Object obj) {
        ClassificationRule cr = (ClassificationRule)obj;
        this.rules.addElement(obj);
        Vector<Object> instrumentRules = (Vector<Object>)this.instRuleSet.get(cr.getInstrument());
        if (instrumentRules == null) {
            instrumentRules = new Vector<Object>();
            this.instRuleSet.put(cr.getInstrument(), instrumentRules);
        }
        instrumentRules.addElement(obj);
        this.fireTableDataChanged();
    }

    public final synchronized void setElementAt(Object obj, int index) {
        try {
            this.rules.setElementAt(obj, index);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println(e2.toString());
        }
        this.fireTableDataChanged();
    }

    public final boolean moveElementDown(ClassificationRule selectedRule) {
        int index = this.rules.indexOf(selectedRule);
        if (index == this.rules.size() - 1) {
            return false;
        }
        ClassificationRule displacedRule = (ClassificationRule)this.rules.elementAt(index + 1);
        this.rules.setElementAt(displacedRule, index);
        this.rules.setElementAt(selectedRule, index + 1);
        if (selectedRule.getInstrument().equals(displacedRule.getInstrument())) {
            Vector instrumentRules = (Vector)this.instRuleSet.get(selectedRule.getInstrument());
            if (instrumentRules != null) {
                int index2 = instrumentRules.indexOf(selectedRule);
                displacedRule = (ClassificationRule)instrumentRules.elementAt(index2 + 1);
                instrumentRules.setElementAt(selectedRule, index2 + 1);
                instrumentRules.setElementAt(displacedRule, index2);
            } else {
                System.err.println("Internal error in RuleTable");
            }
        }
        this.fireTableDataChanged();
        return true;
    }

    public final boolean moveElementUp(ClassificationRule selectedRule) {
        int index = this.rules.indexOf(selectedRule);
        if (index == 0) {
            return false;
        }
        ClassificationRule displacedRule = (ClassificationRule)this.rules.elementAt(index - 1);
        this.rules.setElementAt(displacedRule, index);
        this.rules.setElementAt(selectedRule, index - 1);
        if (selectedRule.getInstrument().equals(displacedRule.getInstrument())) {
            Vector instrumentRules = (Vector)this.instRuleSet.get(selectedRule.getInstrument());
            if (instrumentRules != null) {
                int index2 = instrumentRules.indexOf(selectedRule);
                displacedRule = (ClassificationRule)instrumentRules.elementAt(index2 - 1);
                instrumentRules.setElementAt(selectedRule, index2 - 1);
                instrumentRules.setElementAt(displacedRule, index2);
            } else {
                System.err.println("Internal error in RuleTable");
            }
        }
        this.fireTableDataChanged();
        return true;
    }

    public static RuleTable readFile(String tablePath) {
        RuleTable rc = null;
        try {
            rc = RuleTable.readFileEx(tablePath);
        }
        catch (ClassNotFoundException e2) {
            if (PropertyDB.getInstance().isDebug(7)) {
                System.out.println("Error reading file: " + tablePath + " " + e2.toString());
            }
            rc = null;
        }
        catch (IOException e3) {
            if (PropertyDB.getInstance().isDebug(7)) {
                System.out.println("Error reading file: " + tablePath + " " + e3.toString());
            }
            rc = new RuleTable(tablePath);
            rc.setup(new Vector());
        }
        return rc;
    }

    public static RuleTable readFileEx(String tablePath) throws ClassNotFoundException, IOException {
        RuleTable rc = new RuleTable(tablePath);
        UpgradingObjectInputStream in = new UpgradingObjectInputStream(new FileInputStream(tablePath), "org.eso.gasgano.", "org.eso.gasgano.keyword.");
        Vector ruleSet = (Vector)in.readObject();
        rc.setup(ruleSet);
        return rc;
    }

    public void importFile(String tablePath) {
        block4: {
            try {
                this.importFileEx(tablePath);
            }
            catch (ClassNotFoundException e2) {
                if (PropertyDB.getInstance().isDebug(7)) {
                    System.out.println("Error importing file: " + tablePath + " " + e2.toString());
                }
            }
            catch (IOException e3) {
                if (!PropertyDB.getInstance().isDebug(7)) break block4;
                System.out.println("Error importing  file: " + tablePath + " " + e3.toString());
            }
        }
    }

    public void importFileEx(String tablePath) throws IOException, ClassNotFoundException {
        UpgradingObjectInputStream in = new UpgradingObjectInputStream(new FileInputStream(tablePath), "org.eso.gasgano.", "org.eso.gasgano.keyword.");
        Vector ruleSet = (Vector)in.readObject();
        Enumeration e2 = ruleSet.elements();
        while (e2.hasMoreElements()) {
            this.addElement(e2.nextElement());
        }
    }

    public void writeFile() throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.getTablePath()));
        out.writeObject(this.rules);
        out.close();
    }

    private void setup(Vector ruleSet) {
        Enumeration e2 = ruleSet.elements();
        this.rules = new Vector();
        this.instRuleSet = new Hashtable();
        while (e2.hasMoreElements()) {
            this.addElement(e2.nextElement());
        }
    }

    public static void main(String[] args) {
        if (args.length != 1 || args[0].equals("-v")) {
            System.out.println("RuleTable usage: [-v | <classification.rul file>]");
            System.exit(0);
        } else {
            File rulFile = new File(args[0]);
            if (rulFile.exists()) {
                if (rulFile.canRead()) {
                    RuleTable tbl = null;
                    try {
                        tbl = RuleTable.readFileEx(args[0]);
                    }
                    catch (ClassNotFoundException e2) {
                        System.out.println("Error reading file: " + e2.toString());
                    }
                    catch (IOException e3) {
                        System.out.println("Error reading file: " + e3.toString());
                    }
                    if (tbl != null) {
                        for (int i = 0; i < tbl.getRowCount(); ++i) {
                            int p;
                            ClassificationRule rul = tbl.elementAt(i);
                            System.out.print(rul.getInstrument());
                            for (p = rul.getInstrument().length(); p < 15; ++p) {
                                System.out.print(" ");
                            }
                            System.out.print(rul.getClassification());
                            for (p = rul.getClassification().length(); p < 20; ++p) {
                                System.out.print(" ");
                            }
                            System.out.println(rul.getRule().toString());
                        }
                    }
                } else {
                    System.out.println("Can not read " + args[0] + ".");
                    System.exit(0);
                }
            } else {
                System.out.println("File " + args[0] + " does not exist.");
                System.exit(0);
            }
        }
    }
}

