/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.viewers;

import java.io.IOException;
import java.util.Vector;
import org.eso.gasgano.viewers.ExternalViewer;
import org.eso.gasgano.viewers.ExternalViewerException;

public class ShellCommandExternalViewer
implements ExternalViewer {
    private String shCommand;

    @Override
    public void setCommand(String command) {
        this.shCommand = command;
    }

    @Override
    public void displayFiles(Vector filePaths) throws ExternalViewerException {
        if (filePaths == null || filePaths.size() < 1) {
            throw new ExternalViewerException("Invalid or empty file paths argument.");
        }
        StringBuffer files = new StringBuffer();
        for (int i = 0; i < filePaths.size(); ++i) {
            files.append(" " + filePaths.elementAt(i).toString());
        }
        this.runCommand(this.shCommand + files.toString());
    }

    private int runCommand(String command) throws ExternalViewerException {
        int rc = -1;
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(command);
            try {
                p.waitFor();
                rc = p.exitValue();
            }
            catch (InterruptedException ie) {
                System.out.println("Interrupted while executing: " + ie.toString());
                throw new ExternalViewerException(ie.getMessage());
            }
            catch (IllegalThreadStateException ie) {
                System.out.println("Interrupted while executing: " + ie.toString());
                throw new ExternalViewerException(ie.getMessage());
            }
        }
        catch (IOException e2) {
            System.out.println("Error executing command: " + e2.toString());
            throw new ExternalViewerException(e2.getMessage());
        }
        return rc;
    }
}

