/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.fits;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eso.oca.fits.KeywordNotFoundException;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.fits.UndefinedValueException;
import org.eso.oca.fits.UntypedFITSValue;

public class OCAFile
implements Comparable {
    private Hashtable cards = new Hashtable();
    private Hashtable metaCards = new Hashtable();
    public static final String INSTRUME = "INSTRUME";
    public static final Object OBS_ID = "OBS.ID";
    public static final Object OBS_PROG_ID = "OBS.PROG.ID";
    public static final String DPR_CATG = "DPR.CATG";
    public static final String PRO_CATG = "PRO.CATG";
    public static final String MJD_OBS = "MJD-OBS";
    public static final String TPL_START = "TPL.START";
    public static final String TPL_NEXP = "TPL.NEXP";
    public static final String TPL_EXPNO = "TPL.EXPNO";
    public static final String EXPTIME = "EXPTIME";
    public static final String PIPEFILE = "PIPEFILE";
    public static final String DO_CATG = "DO.CATG";
    public static final String LF_DO_CATG = "LF.DO.CATG";
    public static final String DO_MAX_TEMPLATE_EXPOSURES = "DO.MAX.TEMPLATE.EXPOSURES";
    public static final String DO_TEMPLATE_PREFIX = "DO.TEMPLATE.";
    public static final String DO_TEMPLATE_VAR_INFIX = ".VAR.";
    public static final String DO_TEMPLATE_LOG_SUFFIX = ".LOG";
    public static final String DO_TEMPLATES = "DO.TEMPLATES";
    public static final String SIG_FRAME = "SIG.FRAME";
    public static final String SIG_TEMPLATE = "SIG.TEMPLATE";
    public static final String SIG_TEMPLATE_NAME = "SIG.TEMPLATE.NAME";
    public static final String SIG_DAYTIME = "SIG.DAYTIME";
    public static final String DO_CLASS = "DO.CLASS";
    public static final String RAW_TYPE = "RAW.TYPE";
    public static final String CATG = "CATG";
    public static final String MJD_OBS_MOD = "MJD-OBS.MOD";
    public static final String FILENAME = "FILENAME";
    public static final String LINKNAME = "LINKNAME";
    public static final String OLAS_ID = "OLAS-ID";
    public static final String DP_ID = "DP.ID";
    public static final String PRO_EXT = "PRO.EXT";
    public static final String PACK_DIR = "PACK.DIR";
    public static final String AB_NAME = "AB.NAME";
    public static final String ALIAS = "ALIAS";
    public static final String VIRTUAL = "VIRTUAL";
    public static final String UNDEFINED = "UNDEFINED";
    public static final String DATE = "DATE";
    private String dpId = null;
    static Logger logger = Logger.getLogger(OCAFile.class);

    public OCAFile() {
    }

    public OCAFile(Hashtable keys) {
        if (keys == null) {
            throw new IllegalArgumentException("null keywords");
        }
        this.cards = keys;
    }

    public OCAFile(OCAFile aFile) {
        this.cards = new Hashtable(aFile.getCards());
        this.metaCards = new Hashtable(aFile.getMetaCards());
    }

    public Hashtable getCards() {
        return this.cards;
    }

    public void setCard(String key, Object val) {
        logger.trace("OCAFile::setCard()");
        if (key == null || val == null) {
            String message = "OCAFile::setCard() - key [" + key + "] and val" + (val == null ? " [null]" : "") + " must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (TypedHeaderCard.findFITSType(val) == 0) {
            String message = "OCAFile::setCard() - could not set keyword [" + key + "] to a value of unknown type [" + TypedHeaderCard.findFITSTypeString(val) + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        logger.debug("OCAFile::setCard() - setting keyword [" + key + "] to a value of type [" + TypedHeaderCard.findFITSTypeString(val) + "].");
        this.cards.put(key, val);
    }

    public Hashtable getMetaCards() {
        return this.metaCards;
    }

    public void setMetaCard(String metaKey, Object metaVal) {
        logger.trace("OCAFile::setMetaCard()");
        if (metaKey == null || metaVal == null) {
            String message = "OCAFile::setMetaCard() - metaKey [" + metaKey + "] and metaVal" + (metaVal == null ? " [null]" : "") + " must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (TypedHeaderCard.findFITSType(metaVal) == 0) {
            String message = "OCAFile::setMetaCard() - could not set metakeyword [" + metaKey + "] to a value of unknown type [" + TypedHeaderCard.findFITSTypeString(metaVal) + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        logger.trace("OCAFile::setMetaCard() - setting metakeyword [" + metaKey + "] to a value of type [" + TypedHeaderCard.findFITSTypeString(metaVal) + "].");
        this.metaCards.put(metaKey, metaVal);
    }

    public void addMetaCard(String metaKey, String metaVal) {
        logger.trace("OCAFile::addMetaCard(String, String)");
        this.setMetaCard(metaKey, metaVal);
    }

    public void addMetaCard(String metaKey, BigInteger metaVal) {
        logger.trace("OCAFile::addMetaCard(String, BigInteger)");
        this.setMetaCard(metaKey, metaVal);
    }

    public String getFilename() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(FILENAME);
    }

    public String getLinkname() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(LINKNAME);
    }

    public String getAlias() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(ALIAS);
    }

    public String getDprCatg() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(DPR_CATG);
    }

    public String getProCatg() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(PRO_CATG);
    }

    public String getDoClass() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(DO_CLASS);
    }

    public String getDoCatg() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(DO_CATG);
    }

    public String getLastFrameDoCatg() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(LF_DO_CATG);
    }

    public String getTplNexp() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(TPL_NEXP);
    }

    public String getTplExpno() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(TPL_EXPNO);
    }

    public String getRawType() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(RAW_TYPE);
    }

    public String getCatg() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(CATG);
    }

    public BigDecimal getMjdObs() throws KeywordNotFoundException, UndefinedValueException {
        return new BigDecimal(this.getKeywordValue(MJD_OBS));
    }

    public String getInstrument() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(INSTRUME);
    }

    public String getPipefile() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(PIPEFILE);
    }

    public String getProductExtension() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(PRO_EXT);
    }

    public String getPackDir() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(PACK_DIR);
    }

    public String getDate() throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(DATE);
    }

    public String getABName() throws KeywordNotFoundException, UndefinedValueException {
        String abName = null;
        String pipefile = null;
        Object value = this.metaCards.get(AB_NAME);
        if (value == null) {
            pipefile = this.getKeywordValue(PIPEFILE);
        } else {
            abName = value.toString();
        }
        if (pipefile != null) {
            abName = pipefile;
            int ix = 0;
            if (abName.indexOf("r.") == 0) {
                abName = abName.substring(2);
            }
            if ((ix = abName.indexOf("_0")) > 1) {
                abName = abName.substring(0, ix) + ".ab";
            }
        }
        return abName;
    }

    public boolean isVirtual() {
        return this.cards.containsKey(VIRTUAL) || this.metaCards.containsKey(VIRTUAL);
    }

    private String getKeywordValue(String kw, boolean forSQL) throws KeywordNotFoundException, UndefinedValueException {
        Object val = this.cards.get(kw);
        if (val == null) {
            val = this.metaCards.get(kw);
        }
        if (val == null) {
            String msg = "Requested keyword " + kw + " is not available";
            logger.info(msg);
            throw new KeywordNotFoundException(msg);
        }
        if (val instanceof UntypedFITSValue) {
            String msg = "Requested keyword " + kw + " has undefined type";
            logger.error(msg);
            throw new KeywordNotFoundException(msg);
        }
        if (val instanceof UndefinedFITSValue) {
            String msg = "Requested keyword " + kw + " has undefined value";
            logger.info(msg);
            throw new UndefinedValueException(msg);
        }
        String retVal = val instanceof String && forSQL ? "'" + val.toString() + "'" : val.toString();
        return retVal;
    }

    public String getKeywordValue(String kw) throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(kw, false);
    }

    public String getKeywordValueForSQL(String kw) throws KeywordNotFoundException, UndefinedValueException {
        return this.getKeywordValue(kw, true);
    }

    public void setDpId(String dpId) {
        this.dpId = dpId;
    }

    public String getDpId() throws KeywordNotFoundException, UndefinedValueException {
        if (this.dpId == null) {
            File f = new File(this.getFilename());
            String basename = f.getName();
            int indexOfLastDot = basename.lastIndexOf(46);
            this.dpId = indexOfLastDot > 0 ? basename.substring(0, indexOfLastDot) : UNDEFINED;
        }
        return this.dpId;
    }

    public static String getCanonicalPath(String fullPath) {
        String rc = null;
        try {
            File file = new File(fullPath);
            rc = file.getCanonicalPath();
        }
        catch (IOException e2) {
            rc = null;
        }
        return rc;
    }

    public int compareTo(Object o) {
        try {
            return this.getMjdObs().compareTo(((OCAFile)o).getMjdObs());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage());
        }
    }
}

