/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTBetween
extends SimpleNode {
    static Logger logger = Logger.getLogger(ASTBetween.class);

    public ASTBetween(int id) {
        super(id);
    }

    public ASTBetween(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public int precedence() {
        return 30;
    }

    Boolean between(Object left, Object right1, Object right2) throws InterpretationException {
        String message = this.getNodeLocationString() + "Operator 'between' may not be used for \"" + TypedHeaderCard.findFITSTypeString(left) + " between " + TypedHeaderCard.findFITSTypeString(right1) + " and " + TypedHeaderCard.findFITSTypeString(right2) + "\".";
        logger.error(message);
        throw new InterpretationException(message);
    }

    Boolean between(BigDecimal left, BigInteger right1, BigInteger right2) {
        return left.compareTo(new BigDecimal(right1)) == 1 && left.compareTo(new BigDecimal(right2)) == -1;
    }

    Boolean between(BigDecimal left, BigInteger right1, BigDecimal right2) {
        return left.compareTo(new BigDecimal(right1)) == 1 && left.compareTo(right2) == -1;
    }

    Boolean between(BigDecimal left, BigDecimal right1, BigInteger right2) {
        return left.compareTo(right1) == 1 && left.compareTo(new BigDecimal(right2)) == -1;
    }

    Boolean between(BigDecimal left, BigDecimal right1, BigDecimal right2) {
        return left.compareTo(right1) == 1 && left.compareTo(right2) == -1;
    }

    Boolean between(BigInteger left, BigInteger right1, BigInteger right2) {
        return left.compareTo(right1) == 1 && left.compareTo(right2) == -1;
    }

    Boolean between(BigInteger left, BigInteger right1, BigDecimal right2) {
        BigDecimal leftD = new BigDecimal(left);
        return leftD.compareTo(new BigDecimal(right1)) == 1 && leftD.compareTo(right2) == -1;
    }

    Boolean between(BigInteger left, BigDecimal right1, BigInteger right2) {
        BigDecimal leftD = new BigDecimal(left);
        return leftD.compareTo(right1) == 1 && left.compareTo(right2) == -1;
    }

    Boolean between(BigInteger left, BigDecimal right1, BigDecimal right2) {
        BigDecimal leftD = new BigDecimal(left);
        return leftD.compareTo(right1) == 1 && leftD.compareTo(right2) == -1;
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.trace("interpret() called.");
        ++state.opCounter;
        this.jjtGetChild(0).interpret(state);
        this.jjtGetChild(1).interpret(state);
        this.jjtGetChild(2).interpret(state);
        state.top -= 2;
        state.stack[state.top] = this.dispatch(this.getClass(), "between", new Object[]{state.stack[state.top], state.stack[state.top + 1], state.stack[state.top + 2]});
    }
}

