/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.oca.backend.AssociationBlock;
import org.eso.oca.fits.OCAFile;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.parser.ASTActionRule;
import org.eso.oca.parser.ASTIfStatement;
import org.eso.oca.parser.ASTSelectExecuteStatement;
import org.eso.oca.parser.ASTStart;
import org.eso.oca.parser.DispatchHelper;
import org.eso.oca.parser.DispatchNoSuchMethodException;
import org.eso.oca.parser.DispatchReflectionError;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.Node;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserTreeConstants;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected OcaParser parser;
    protected Token first;
    protected Token last;
    static Logger logger = Logger.getLogger(SimpleNode.class);
    public final int LOGICAL_OR_PRECEDENCE = 10;
    public final int LOGICAL_AND_PRECEDENCE = 20;
    public final int LOGICAL_NOT_PRECEDENCE = 25;
    public final int COMPARISON_PRECEDENCE = 30;
    public final int ADDITION_PRECEDENCE = 40;
    public final int MULTIPLICATION_PRECEDENCE = 50;
    public final int DEFAULT_PRECEDENCE = 100;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(OcaParser p, int i) {
        this(i);
        this.parser = p;
    }

    public static Node jjtCreate(OcaParser p, int id) {
        return new SimpleNode(p, id);
    }

    @Override
    public void jjtOpen() {
        this.first = this.parser.getToken(1);
    }

    @Override
    public void jjtClose() {
        this.last = this.parser.getToken(0);
    }

    public Token getFirstToken() {
        return this.first;
    }

    public Token getLastToken() {
        return this.last;
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c2 = new Node[i + 1];
            System.arraycopy(this.children, 0, c2, 0, this.children.length);
            this.children = c2;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public int precedence() {
        return 100;
    }

    public String toString() {
        return OcaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public String[] getRequestedData() {
        String[] requestedData = new String[this.getKeywordCorpus().size()];
        int i = 0;
        Iterator it = this.getKeywordCorpus().iterator();
        while (it.hasNext()) {
            requestedData[i++] = (String)it.next();
        }
        return requestedData;
    }

    protected String getNodeLocationString() {
        return "Rule file (Line " + this.getFirstToken().beginLine + ", Column " + this.getFirstToken().beginColumn + "): ";
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.debug("SimpleNode interpret() method should never be called.");
        throw new RuntimeException("SimpleNode interpret() method should never be called.");
    }

    protected Object dispatch(Class callingClass, String methodName, Object[] args) throws InterpretationException {
        Method methodToCall = DispatchHelper.getNearestMethod(callingClass, methodName, args);
        if (methodToCall == null) {
            String message = "dispatch() unable to find method.";
            logger.debug(message);
            throw new DispatchNoSuchMethodException(message);
        }
        logger.trace("dispatch() found method, calling now.");
        try {
            return methodToCall.invoke((Object)this, args);
        }
        catch (InvocationTargetException ite) {
            String message = "The method called by dispatch() threw an exception.";
            logger.error(message);
            throw new InterpretationException(message, ite.getCause());
        }
        catch (Exception e2) {
            String message = "An irretrievable error occurred during the reflection and dispatching process. This may indicate a bug. Please report it to an OCA maintainer.";
            logger.error(message);
            throw new DispatchReflectionError(message, e2);
        }
    }

    private Object makeBoolean(Object value) throws InterpretationException {
        String message = this.getNodeLocationString() + "Type '" + TypedHeaderCard.findFITSTypeString(value) + "' may not be converted to 'BOOLEAN'.";
        logger.error(message);
        throw new InterpretationException(message);
    }

    private Boolean makeBoolean(UndefinedFITSValue value) {
        String message = this.getNodeLocationString() + "Converting '" + TypedHeaderCard.findFITSTypeString(value) + "' to 'BOOLEAN'.";
        logger.warn(message);
        return new Boolean(false);
    }

    private Boolean makeBoolean(Boolean value) {
        return value;
    }

    protected Object getBoolean(Object value) throws InterpretationException {
        return this.dispatch(SimpleNode.class, "makeBoolean", new Object[]{value});
    }

    private ASTStart getTreeRoot() {
        SimpleNode currentNode = this;
        Node parentNode = this;
        while (parentNode != null) {
            currentNode = parentNode;
            parentNode = currentNode.jjtGetParent();
        }
        return (ASTStart)currentNode;
    }

    public Collection getKeywordCorpus() {
        return Collections.unmodifiableCollection(this.getTreeRoot().getModifiableKeywordCorpus());
    }

    Collection getModifiableKeywordCorpus() {
        return this.getTreeRoot().getModifiableKeywordCorpus();
    }

    public Collection getMetaKeywordCorpus() {
        return Collections.unmodifiableCollection(this.getTreeRoot().getModifiableMetaKeywordCorpus());
    }

    Collection getModifiableMetaKeywordCorpus() {
        return this.getTreeRoot().getModifiableMetaKeywordCorpus();
    }

    public List getClassificationRules() {
        return Collections.unmodifiableList(this.getTreeRoot().getModifiableClassificationRules());
    }

    List getModifiableClassificationRules() {
        return this.getTreeRoot().getModifiableClassificationRules();
    }

    public List getOrganisationRules() {
        return Collections.unmodifiableList(this.getTreeRoot().getModifiableOrganisationRules());
    }

    List getModifiableOrganisationRules() {
        return this.getTreeRoot().getModifiableOrganisationRules();
    }

    public Map getAssociationRules() {
        return Collections.unmodifiableMap(this.getTreeRoot().getModifiableAssociationRules());
    }

    Map getModifiableAssociationRules() {
        return this.getTreeRoot().getModifiableAssociationRules();
    }

    public OCAFile[] classify(OCAFile[] files) throws InterpretationException {
        OCAState state = new OCAState();
        state.opCounter = 0L;
        for (int i = 0; i < files.length; ++i) {
            state.symtab = new Hashtable(files[i].getCards());
            List classificationRules = this.getClassificationRules();
            for (int j = 0; j < classificationRules.size(); ++j) {
                ((ASTIfStatement)classificationRules.get(j)).interpret(state);
            }
            for (String metaKey : this.getMetaKeywordCorpus()) {
                Object metaVal = null;
                Object v = state.symtab.get(metaKey);
                metaVal = v;
                if (v != null) {
                    files[i].setMetaCard(metaKey, metaVal);
                    continue;
                }
                files[i].setMetaCard(metaKey, new UndefinedFITSValue());
            }
            try {
                String msg = files[i].getFilename() + " : " + files[i].getMetaCards().toString();
                logger.info(msg);
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        logger.debug("operation count : " + state.opCounter);
        return files;
    }

    public AssociationBlock[] organize(OCAFile[] files) throws InterpretationException {
        OCAState state = new OCAState();
        state.opCounter = 0L;
        Vector<AssociationBlock> assocBlocks = new Vector<AssociationBlock>();
        List organisationRules = this.getOrganisationRules();
        for (int i = 0; i < organisationRules.size(); ++i) {
            Vector<OCAFile> selectedFiles = new Vector<OCAFile>();
            ASTSelectExecuteStatement organisationRule = (ASTSelectExecuteStatement)organisationRules.get(i);
            for (int j = 0; j < files.length; ++j) {
                state.symtab = new Hashtable(files[j].getCards());
                state.symtab.putAll(files[j].getMetaCards());
                organisationRule.interpret(state);
                if (!state.isSelected) continue;
                selectedFiles.add(files[j]);
            }
            String msg = selectedFiles.size() + " files selected by organization rule #" + i;
            if (selectedFiles.size() == 0) {
                logger.debug(msg);
            } else {
                logger.info(msg);
            }
            if (selectedFiles.size() == 0) continue;
            String[] matchKeywords = organisationRule.matchKeywords;
            OCAFile[] setOfFiles = selectedFiles.toArray(new OCAFile[0]);
            Vector groups = this.makeGroups(setOfFiles, matchKeywords);
            msg = groups.size() + " groups selected by organization rule #" + i;
            logger.info(msg);
            String action = organisationRule.action;
            String groupEvent = organisationRule.groupEvent;
            String groupEventExt = organisationRule.groupEventExt;
            for (OCAFile[] rawFiles : groups) {
                AssociationBlock ab = new AssociationBlock();
                if (rawFiles.length < state.minRet) {
                    String errmsg = "Not enough associated files for organisation rule #" + i + ": requested " + state.minRet + ", found " + rawFiles.length;
                    logger.error(errmsg);
                    ab.getMessages().add(errmsg);
                    ab.setMinRequestedFiles(state.minRet);
                    ab.setValid(false);
                }
                ab.setInputFiles(rawFiles);
                ab.setAction(action);
                ab.setGroupEvent(groupEvent);
                ab.setGroupEventExt(groupEventExt);
                ab.setMatchKeywords(matchKeywords);
                assocBlocks.add(ab);
            }
            state.minRet = 1;
        }
        logger.debug("operation count : " + state.opCounter);
        return assocBlocks.toArray(new AssociationBlock[0]);
    }

    private Vector makeGroups(OCAFile[] files, String[] matchKeywords) {
        Vector<OCAFile[]> ret = new Vector<OCAFile[]>();
        if (matchKeywords.length == 0) {
            ret.add(files);
            return ret;
        }
        Hashtable groups = new Hashtable();
        for (int i = 0; i < files.length; ++i) {
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < matchKeywords.length; ++j) {
                String matchVal;
                String matchKey = matchKeywords[j];
                try {
                    matchVal = files[i].getKeywordValue(matchKey);
                }
                catch (Exception e2) {
                    matchVal = "NULL";
                }
                buf.append(matchKey + "=" + matchVal + ";");
            }
            String groupKey = buf.toString();
            if (groups.containsKey(groupKey)) {
                ((Vector)groups.get(groupKey)).add(files[i]);
                try {
                    logger.info("added " + files[i].getFilename() + " to current group");
                }
                catch (Exception e3) {}
                continue;
            }
            Vector<OCAFile> tmp = new Vector<OCAFile>();
            tmp.add(files[i]);
            groups.put(groupKey, tmp);
            logger.info("created new group with match values : " + groupKey);
            try {
                logger.info("added " + files[i].getFilename() + " to current group");
                continue;
            }
            catch (Exception e4) {
                // empty catch block
            }
        }
        for (String key : groups.keySet()) {
            logger.debug("group key \"" + key);
            Vector v = (Vector)groups.get(key);
            OCAFile[] of = v.toArray(new OCAFile[0]);
            ret.add(of);
        }
        return ret;
    }

    public AssociationBlock[] associate(AssociationBlock[] assocBlocks, OCAFile[] rawFiles, OCAFile[] calibFiles) throws InterpretationException {
        int i;
        OCAState state = new OCAState();
        state.opCounter = 0L;
        state.globCalibFiles = new Vector();
        state.globInputFiles = new Vector();
        for (i = 0; i < calibFiles.length; ++i) {
            Hashtable<String, UndefinedFITSValue> ctab = new Hashtable<String, UndefinedFITSValue>(calibFiles[i].getCards());
            ctab.putAll(calibFiles[i].getMetaCards());
            for (String metaKeyword : this.getMetaKeywordCorpus()) {
                if (ctab.containsKey(metaKeyword)) continue;
                ctab.put(metaKeyword, new UndefinedFITSValue());
            }
            state.globCalibFiles.add(ctab);
        }
        for (i = 0; i < rawFiles.length; ++i) {
            Hashtable<String, UndefinedFITSValue> rtab = new Hashtable<String, UndefinedFITSValue>(rawFiles[i].getCards());
            rtab.putAll(rawFiles[i].getMetaCards());
            for (String metaKeyword : this.getMetaKeywordCorpus()) {
                if (rtab.containsKey(metaKeyword)) continue;
                rtab.put(metaKeyword, new UndefinedFITSValue());
            }
            state.globInputFiles.add(rtab);
        }
        Map associationRules = this.getAssociationRules();
        for (int i2 = 0; i2 < assocBlocks.length; ++i2) {
            ASTActionRule actionRule = (ASTActionRule)associationRules.get(assocBlocks[i2].getAction());
            if (actionRule == null) {
                logger.error("undefined action " + assocBlocks[i2].getAction());
                continue;
            }
            logger.info("invoking action " + actionRule.name + " for group " + i2);
            state.inputFileSymtab = new Hashtable(assocBlocks[i2].getExemplar().getCards());
            state.inputFileSymtab.putAll(assocBlocks[i2].getExemplar().getMetaCards());
            try {
                state.inputFileSymtab.put("MJD-OBS.MOD", assocBlocks[i2].getModifiedMjdObs());
            }
            catch (Exception e2) {
                logger.debug("Can't add modified MJD-OBS to inputFileSymtab");
            }
            state.associatedFiles = new Vector();
            state.selectionBlocks = new Vector();
            state.globVirtualProducts = new Vector();
            state.isABValid = true;
            actionRule.interpret(state);
            OCAFile[] assoc = new OCAFile[state.associatedFiles.size()];
            for (int j = 0; j < state.associatedFiles.size(); ++j) {
                assoc[j] = new OCAFile((Hashtable)state.associatedFiles.elementAt(j));
            }
            OCAFile[] prods = new OCAFile[state.globVirtualProducts.size()];
            for (int j = 0; j < state.globVirtualProducts.size(); ++j) {
                prods[j] = new OCAFile((Hashtable)state.globVirtualProducts.elementAt(j));
            }
            AssociationBlock ab = assocBlocks[i2];
            ArrayList<OCAFile> ifList = new ArrayList<OCAFile>(Arrays.asList(ab.getInputFiles()));
            for (int j = 0; j < state.extraInputFiles.size(); ++j) {
                ifList.add(new OCAFile((Hashtable)state.extraInputFiles.elementAt(j)));
            }
            ab.setInputFiles(ifList.toArray(new OCAFile[0]));
            ab.setAssociatedFiles(assoc);
            ab.setSelectionBlocks(state.getSelectionBlocks());
            ab.setProductFiles(prods);
            ab.setRecipe(state.globRecipe);
            ab.setRecipeParams(state.globRecipeParams);
            ab.setPriority(state.priority);
            ab.setValid(state.isABValid && ab.isValid());
            OCAFile[] modifiedProducts = assocBlocks[i2].getProductFiles();
            for (int j = 0; j < modifiedProducts.length; ++j) {
                Hashtable t = new Hashtable(modifiedProducts[j].getCards());
                t.putAll(modifiedProducts[j].getMetaCards());
                state.globCalibFiles.add(t);
            }
            state.priority = 50;
        }
        logger.debug("operation count : " + state.opCounter);
        return assocBlocks;
    }
}

